<?php
namespace Drop\Taxclass\Helper;

use Magento\Store\Model\ScopeInterface;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    const XML_PATH_ENABLED = 'manage_product_taxclass/settings/enable';
    const XML_PATH_REINDEX = 'manage_product_taxclass/settings/reindex';
    const XML_PATH_ALLOWED_STORES = 'manage_product_taxclass/settings/stores';
    const XML_PATH_PRICE_LIMIT = 'manage_product_taxclass/settings/price_limit';
    const XML_PATH_TAX_CLASS_ID_BELOW = 'manage_product_taxclass/settings/below_limit_class';
    const XML_PATH_TAX_CLASS_ID_UP = 'manage_product_taxclass/settings/up_limit_class';
    const XML_PATH_APPLY_ONLY_TO_CONFIGURABLE = 'manage_product_taxclass/settings/only_configurable';

    protected $scopeConfig;

    /**
     * Data constructor.
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
    )
    {
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * @param $field
     * @param null $storeId
     * @return mixed
     */
    public function getConfigValue($field, $storeId = null)
    {
        return $this->scopeConfig->getValue(
            $field, ScopeInterface::SCOPE_STORE, $storeId
        );
    }

    /**
     * @return mixed
     */
    public function isEnabled()
    {
        return $this->getConfigValue(self::XML_PATH_ENABLED);
    }

    /**
     * @return mixed
     */
    public function canReindex()
    {
        return $this->getConfigValue(self::XML_PATH_REINDEX);
    }

    /**
     * @return mixed
     */
    public function applyOnlyToConfigurable()
    {
        return $this->getConfigValue(self::XML_PATH_APPLY_ONLY_TO_CONFIGURABLE);
    }

    /**
     * @return array
     */
    public function getAllowedStores()
    {
        return explode(",", $this->getConfigValue(self::XML_PATH_ALLOWED_STORES));
    }

    /**
     * @param $storeId
     * @return mixed
     */
    public function getPriceLimit($storeId)
    {
        return $this->getConfigValue(self::XML_PATH_PRICE_LIMIT, $storeId);
    }

    /**
     * @param $storeId
     * @return mixed
     */
    public function getTaxClassIdBelow($storeId)
    {
        return $this->getConfigValue(self::XML_PATH_TAX_CLASS_ID_BELOW, $storeId);
    }

    /**
     * @param $storeId
     * @return mixed
     */
    public function getTaxClassIdUp($storeId)
    {
        return $this->getConfigValue(self::XML_PATH_TAX_CLASS_ID_UP, $storeId);
    }
}