<?php

namespace Drop\Taxclass\Cron;

class Manage
{
    protected $helper;
    protected $collectionFactory;
    protected $productFactory;
    protected $indexerFactory;
    protected $indexerCollectionFactory;
    protected $cacheManager;
    protected $productResource;
    protected $log;
    protected $logger;

    /**
     * Manage constructor.
     * @param \Drop\Taxclass\Helper\Data $helper
     * @param \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $collectionFactory
     * @param \Magento\Catalog\Model\ProductFactory $productFactory
     * @param \Magento\Indexer\Model\IndexerFactory $indexerFactory
     * @param \Magento\Indexer\Model\Indexer\CollectionFactory $indexerCollectionFactory
     * @param \Magento\Framework\App\Cache\Manager $cacheManager
     * @param \Magento\Catalog\Model\ResourceModel\Product $productResource
     * @param \Drop\Taxclass\Logger\Logger $logger
     */
    public function __construct(
        \Drop\Taxclass\Helper\Data $helper,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $collectionFactory,
        \Magento\Catalog\Model\ProductFactory $productFactory,
        \Magento\Indexer\Model\IndexerFactory $indexerFactory,
        \Magento\Indexer\Model\Indexer\CollectionFactory $indexerCollectionFactory,
        \Magento\Framework\App\Cache\Manager $cacheManager,
        \Magento\Catalog\Model\ResourceModel\Product $productResource,
        \Drop\Taxclass\Logger\Logger $logger
    )
    {
        $this->helper = $helper;
        $this->collectionFactory = $collectionFactory;
        $this->productFactory = $productFactory;
        $this->indexerFactory = $indexerFactory;
        $this->indexerCollectionFactory = $indexerCollectionFactory;
        $this->cacheManager = $cacheManager;
        $this->productResource = $productResource;
        $this->logger = $logger;
    }

    /**
     * @param null $sku
     * @param null $log
     * @return $this
     * @throws \Exception
     */
    public function execute($sku = null, $log = null)
    {
        if (!$this->helper->isEnabled()) {
            return $this;
        }

        if (is_object($sku)){
            $sku = NULL;
        }
        if (is_object($log)){
            $log = NULL;
        }

        $this->log = $log;

        foreach ($this->helper->getAllowedStores() as $allowedStore) {
            $this->writeLog("StoreId: {$allowedStore}");
            $collection = $this->collectionFactory->create()
                ->addStoreFilter($allowedStore)
                ->addAttributeToSort('created_at', 'DESC')
                ->addAttributeToSelect('*');
            if ($this->helper->applyOnlyToConfigurable()) {
                $collection->addAttributeToFilter('type_id', ['eq' => 'configurable']);
            }
            if ($sku) {
                $collection->addAttributeToFilter('sku', ['eq' => $sku]);
            }

            $cSize = $collection->count();
            $count = 1;
            $this->writeLog("collection size: {$cSize}");
            foreach ($collection as $item) {
                $this->writeLog("{$count} di {$cSize}) {$item->getSku()}");
                $finalPrice = $item->getPriceInfo()->getPrice('final_price')->getAmount()->getValue();
                $newTaxClassId = ($finalPrice > $this->helper->getPriceLimit($allowedStore)) ? $this->helper->getTaxClassIdUp($allowedStore) : $this->helper->getTaxClassIdBelow($allowedStore);

                if ($newTaxClassId == $item->getTaxClassId()) {
                    $count++;
                    continue;
                }

                try {
                    $item->setTaxClassId($newTaxClassId);
                    $this->productResource->saveAttribute($item, 'tax_class_id');
//                    $item->save();
                } catch (\Exception $e) {
                    throw new \Exception($e->getMessage());
                }

                $count++;
            }
        }

        if ($this->helper->canReindex()) {
            $this->reindexAndClearCache();
        }
    }

    public function reindexAndClearCache()
    {
        $ids = $this->indexerCollectionFactory->create()->getAllIds();
        foreach ($ids as $id) {
            $this->indexerFactory->create()->load($id)->reindexAll();
        }

        $this->cacheManager->flush($this->cacheManager->getAvailableTypes());
    }

    /**
     * @param $message
     */
    protected function writeLog($message)
    {
        if (!$this->log) {
            return;
        }

        $this->logger->info($message);
    }
}
