<?php
namespace Drop\Taxclass\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class Apply extends Command
{
    const SKU = 'sku';
    const LOG = 'log';

    protected $state;
    protected $manage;

    /**
     * Apply constructor.
     * @param \Magento\Framework\App\State $state
     * @param \Drop\Taxclass\Cron\Manage $manage
     */
    public function __construct(
        \Magento\Framework\App\State $state,
        \Drop\Taxclass\Cron\Manage $manage
    )
    {
        $this->state = $state;
        $this->manage = $manage;
        parent::__construct();
    }

    protected function configure()
    {
        $options = [
            new InputOption(
                self::SKU,
                null,
                InputOption::VALUE_REQUIRED,
                'single sku'
            ),
            new InputOption(
                self::LOG,
                null,
                InputOption::VALUE_NONE,
                'enable log'
            ),
        ];
        $this->setName('drop:taxclass:apply');
        $this->setDescription('Manual apply tax classes to products');
        $this->setDefinition($options);
        parent::configure();
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @throws \Exception
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        try {
            // this tosses an error if the areacode is not set.
            $this->state->getAreaCode();
        } catch (\Exception $e) {
            $this->state->setAreaCode('adminhtml');
        }

        $output->writeln(date('Y-m-d H:i:s'));

        $output->writeln('tax classes application');
        if($sku = $input->getOption(self::SKU)){
            $output->writeln("sku: {$sku}");
        }
        $log = $input->getOption(self::LOG) ? true : false;
        $this->manage->execute($sku, $log);
        $output->writeln('finish');
        $output->writeln(date('Y-m-d H:i:s'));
    }
}
