<?php

namespace Drop\Klarna\Helper;

use Drop\Klarna\Api\ConfigPathInterface;
use Drop\Klarna\Logger\Logger;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Store\Model\ScopeInterface;

/**
 * @SuppressWarnings(PHPMD.LongVariable)
 */
class Data extends AbstractHelper implements ConfigPathInterface {
    /**
     * @var Logger
     */
    protected $logger;

    /**
     * Data constructor.
     * @param Context $context
     * @param Logger $logger
     */
    public function __construct(
        Context $context,
        Logger $logger
    ) {
        $this->logger = $logger;

        parent::__construct($context);
    }

    /**
     * Returns the config value based on the selected environment
     *
     * @param string $path
     * @return mixed
     */
    public function getConfigValue(string $path) {
        return $this->scopeConfig->getValue(
            $path,
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Returns On Site Messaging Library URL
     *
     * @return mixed
     */
    public function getLibraryUrl() {
        return $this->getConfigValue(
            self::LIBRARY_URL_CONFIG_PATH
        );
    }

    /**
     * Returns On Site Messaging Client ID
     *
     * @return mixed
     */
    public function getClientId() {
        return $this->getConfigValue(
            self::CLIENT_ID_CONFIG_PATH
        );
    }

    /**
     * Returns Payment Capture Mode
     *
     * @return mixed
     */
    public function getCaptureMode() {
        return $this->getConfigValue(
            self::CAPTURE_MODE_CONFIG_PATH
        );
    }

    /**
     * Returns if Klarna Payment Enabled
     *
     * @return mixed
     */
    public function isKlarnaKpEnabled() {
        return $this->getConfigValue(
            self::KLARNA_KP_ENABLED_CONFIG_PATH
        );
    }

    /**
     * Returns if the debug mode is enabled
     *
     * @return bool
     */
    public function isDebugModeEnabled() {
        return $this->getConfigValue(
            self::DEBUG_MODE_CONFIG_PATH
        );
    }

    /**
     * Log message only if debug mode is enabled
     *
     * @param string $message
     * @return bool
     */
    public function logDebug(string $message) {
        if ($this->isDebugModeEnabled()) {
            //Using info instead of debug method because not working properly
            return $this->logger->info($message);
        }
        return false;
    }

    /**
     * Log message based on the level
     *
     * @param string $message
     * @param int $level
     * @return bool
     */
    public function log(string $message, int $level = Logger::INFO) {
        return $this->logger->log($level, $message);
    }
}
