<?php

namespace Drop\Klarna\Helper;

use Drop\Klarna\Api\ConfigPathInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Store\Model\ScopeInterface;

/**
 * @SuppressWarnings(PHPMD.LongVariable)
 */
class Data extends AbstractHelper implements ConfigPathInterface {

    /**
     * Data constructor.
     * @param \Magento\Framework\App\Helper\Context $context
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context
    ) {
        parent::__construct($context);
    }

    /**
     * Returns the config value based on the selected environment
     *
     * @param string $path
     * @return mixed
     */
    public function getConfigValue(string $path) {
        return $this->scopeConfig->getValue(
            $path,
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Returns On Site Messaging Library URL
     *
     * @return mixed
     */
    public function getLibraryUrl() {
        return $this->getConfigValue(
            self::LIBRARY_URL_CONFIG_PATH
        );
    }

    /**
     * Returns On Site Messaging Client ID
     *
     * @return mixed
     */
    public function getClientId() {
        return $this->getConfigValue(
            self::CLIENT_ID_CONFIG_PATH
        );
    }

    /**
     * Returns Payment Capture Mode
     *
     * @return mixed
     */
    public function getCaptureMode() {
        return $this->getConfigValue(
            self::CAPTURE_MODE_CONFIG_PATH
        );
    }

    /**
     * Returns if Klarna Payment Enabled
     *
     * @return mixed
     */
    public function isKlarnaKpEnabled() {
        return $this->getConfigValue(
            self::KLARNA_KP_ENABLED_CONFIG_PATH
        );
    }
}
