<?php
namespace Drop\Klarna\Setup;

use Magento\Cms\Model\PageFactory;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

/**
 * @codeCoverageIgnore
 */
class InstallData implements InstallDataInterface
{
    /**
     * Page factory
     *
     * @var PageFactory
     */
    private $pageFactory;

    /**
     * Init
     *
     * @param PageFactory $pageFactory
     */
    public function __construct(PageFactory $pageFactory)
    {
        $this->pageFactory = $pageFactory;
    }

    /**
     * {@inheritdoc}
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $infoPage = [
            'title' => 'Klarna Infopage',
            'page_layout' => '1column',
            'meta_keywords' => 'Klarna Infopage',
            'meta_description' => 'Klarna Infopage',
            'identifier' => 'klarna-infopage',
            'content_heading' => '',
            'content' => '',
            'is_active' => 1,
            'stores' => [0],
            'sort_order' => 0
        ];

        // Insert Klarna On-Site Message Pages
        $setup->startSetup();
        $this->pageFactory->create()->setData($infoPage)->save();
        $setup->endSetup();
    }
}