<?php
namespace Drop\Klarna\Block;

use Magento\Framework\View\Element\Template\Context;
use Magento\Framework\Locale\Resolver;
use Magento\Framework\Registry;
use Magento\Framework\App\Config\ScopeConfigInterface;

class Template extends \Magento\Framework\View\Element\Template {
    /**
     * @var Context
     */
    private $context;
    /**
     * @var Resolver
     */
    private $locale;
    /**
     * @var Registry
     */
    private $registry;
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * DropTemplate constructor.
     * @param Context $context
     * @param Resolver $locale
     * @param Registry $registry
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        Context $context,
        Resolver $locale,
        Registry $registry,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->context = $context;
        $this->locale = $locale;
        $this->registry = $registry;
        $this->scopeConfig = $scopeConfig;
        parent::__construct($context, $data = []);
    }

    /**
     * @return mixed|null
     */
    public function getCurrentProduct(){
        $currentProduct = $this->registry->registry('current_product');
        return $currentProduct;
    }

    /**
     * @return mixed
     */
    public function getLocale(){
        return $this->locale->getLocale();
    }

    /**
     * @param $path
     * @return mixed
     */
    public function getCoreConfig($path){
        return $this->scopeConfig->getValue($path,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
    }
}