<?php
/**
 * This file is part of the Klarna Kp module
 *
 * (c) Klarna AB
 *
 * For the full copyright and license information, please view the NOTICE
 * and LICENSE files that were distributed with this source code.
 */

namespace Drop\Klarna\Plugin\Klarna\Checkout\Block;

use Klarna\Kp\Model\Payment\Kp;
use Klarna\Kp\Model\Session as KlarnaKpSession;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;

/**
 * This onepage checkout block run before or after specific actions of the magento onepage checkout block
 *
 * @package Klarna\Kp\Plugin\Checkout\Block
 */
class OnepagePlugin
{
    /**
     * @var KlarnaKpSession
     */
    private $kpSession;

    /**
     * @var ScopeConfigInterface
     */
    private $config;

    /** @var StoreManagerInterface */
    private $storeManager;

    /**
     * @var \Magento\Checkout\Model\Session
     */
    protected $checkoutSession;

    /**
     * OnepagePlugin constructor.
     *
     * @param KlarnaKpSession $kpSession
     * @param ScopeConfigInterface $config
     * @param StoreManagerInterface $storeManager
     * @param \Magento\Checkout\Model\Session $checkoutSession
     */
    public function __construct(
        KlarnaKpSession $kpSession,
        ScopeConfigInterface $config,
        StoreManagerInterface $storeManager,
        \Magento\Checkout\Model\Session $checkoutSession
    ) {
        $this->kpSession = $kpSession;
        $this->config = $config;
        $this->storeManager = $storeManager;
        $this->checkoutSession = $checkoutSession;
    }

    /**
     * @return \Magento\Quote\Model\Quote
     */
    public function getQuote() {
        return $this->checkoutSession->getQuote();
    }

    /**
     * Initialize Klarna Payment session before get js layout
     *
     * @throws \Klarna\Core\Exception
     * @throws \Klarna\Core\Model\Api\Exception
     */
    public function beforeGetJsLayout()
    {
        $store = $this->storeManager->getStore();
        if ($this->config->isSetFlag(
            sprintf('payment/%s/active', Kp::METHOD_CODE),
            ScopeInterface::SCOPE_STORES,
            $store
        )) {

            $currentQuote = $this->getQuote();
            if($currentQuote){
                $giftcards = $currentQuote->getMpGiftCards();

                //attiva klarna se non ci sono giftcard
                if(empty($giftcards)) {
                    $this->kpSession->init();
                }
            }
        }
    }
}
