<?php

namespace Drop\Klarna\Observer;

use Magento\Framework\Event\Observer;
use Magento\Payment\Observer\AbstractDataAssignObserver;

/**
 * Class DataAssignObserver
 */
class BeforeShipmentObserver extends AbstractDataAssignObserver
{

    private $klarnaHelper;

    /**
     * BeforeShipmentObserver constructor.
     *
     * @param \Drop\Klarna\Helper\Data $klarnaHelper
     */
    public function __construct(
        \Drop\Klarna\Helper\Data $klarnaHelper
    )
    {
        $this->klarnaHelper = $klarnaHelper;
    }

    /**
     * @param Observer $observer
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function execute(Observer $observer)
    {
        $shipment = $observer->getEvent()->getShipment();
        $order = $shipment->getOrder();
        $captureOnShipment = $this->klarnaHelper->getConfigData('klarna_kp_configuration', 'capture_on_shipment', $order->getStoreId());

        if (!($this->isPaymentMethodKlarna($order) && $captureOnShipment)) {
            return;
        }

        if (!$order->canInvoice()) {
            throw new \Exception(sprintf("Error, can't create invoice."));
        }

        $payment = $order->getPayment();
        try {
            $invoice = $order->prepareInvoice();
            $invoice->getOrder()->setIsInProcess(true);
            $invoice->setRequestedCaptureCase(\Magento\Sales\Model\Order\Invoice::CAPTURE_ONLINE);
            $invoice->register()->pay();
            $invoice->save();
        } catch (\Exception $e) {
            throw new \Exception(sprintf('Error saving invoice. The error message is:', $e->getMessage()));
        }
    }

    /**
     * Determine if the payment method is Klarna
     */
    public function isPaymentMethodKlarna($order)
    {
        return strpos($order->getPayment()->getMethod(), 'klarna') !== false;
    }
}
