<?php
namespace Drop\Klarna\Block;

use Magento\Framework\View\Element\Template\Context;
use Magento\Framework\Locale\Resolver;
use Magento\Framework\Registry;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Drop\Klarna\Helper\Data;

class Template extends \Magento\Framework\View\Element\Template {
    /**
     * @var Context
     */
    private $context;
    /**
     * @var Resolver
     */
    private $locale;
    /**
     * @var Registry
     */
    private $registry;
    /**
     * @var Data
     */
    private $klarnaHelper;

    /**
     * DropTemplate constructor.
     * @param Context $context
     * @param Resolver $locale
     * @param Registry $registry
     * @param Data $klarnaHelper
     */
    public function __construct(
        Context $context,
        Resolver $locale,
        Registry $registry,
        Data $klarnaHelper
    ) {
        $this->context = $context;
        $this->locale = $locale;
        $this->registry = $registry;
        $this->klarnaHelper = $klarnaHelper;
        parent::__construct($context, $data = []);
    }

    /**
     * @return mixed|null
     */
    public function getCurrentProduct(){
        $currentProduct = $this->registry->registry('current_product');
        return $currentProduct;
    }

    /**
     * @return mixed
     */
    public function getLocale(){
        return $this->locale->getLocale();
    }

    /**
     * @return mixed
     */
    public function getLibraryUrl(){
        return $this->klarnaHelper->getLibraryUrl();
    }

    /**
     * @return mixed
     */
    public function getClientId(){
        return $this->klarnaHelper->getClientId();
    }

    /**
     * @return mixed
     */
    public function isKlarnaKpEnabled(){
        return $this->klarnaHelper->isKlarnaKpEnabled();
    }
}
