<?php
namespace Drop\IubendaConsentSolution\Block;

use \Magento\Framework\View\Element\Template;
use \Magento\Framework\View\Element\Template\Context;
use \Drop\IubendaConsentSolution\Helper\Data as HelperData;
use \Magento\Store\Model\StoreManagerInterface as StoreManager;

class Consentsolution extends Template {
    /**
     * @var HelperData
     */
	protected $helperData;
    /**
     * @var StoreManager
     */
    protected $_storeManager;

    /**
     * Consentsolution constructor.
     * @param Context $context
     * @param HelperData $helperData
     * @param StoreManager $storeManager
     * @param array $data
     */
    public function __construct(
        Context $context,
        HelperData $helperData,
        StoreManager $storeManager,
        array $data = []
    ) {
        $this->helperData = $helperData;
        $this->_storeManager = $storeManager;

        parent::__construct($context, $data);
    }

    /**
     * @return HelperData
     */
	public function getHelper() {
		return $this->helperData;
	}

    /**
     * Get store identifier
     *
     * @return  int
     */
    public function getStoreId() {
        return $this->_storeManager->getStore()->getId();
    }

    /**
     * Public Api Key
     * @return bool|mixed
     */
	public function getPublicApiKey() {
        return $this->helperData->getConfigValue($this->helperData::PUBLIC_API_KEY_CONFIG_PATH);
    }
}
