<?php
declare(strict_types=1);

namespace Drop\IubendaConsentSolution\Observer\Newsletter\Subscriber;

use Drop\IubendaConsentSolution\Helper\Data as HelperData;
use Drop\IubendaConsentSolution\Model\Api\Client as ApiClient;
use Magento\Framework\App\RequestInterface;

class SaveAfter implements \Magento\Framework\Event\ObserverInterface {
    /**
     * @var ApiClient
     */
    protected $apiClient;

    /**
     * @var HelperData
     */
    protected $helperData;

    /**
     * @var RequestInterface
     */
    protected $request;

    /**
     * @param ApiClient $apiClient
     * @param HelperData $helperData
     * @param RequestInterface $request
     */
    public function __construct(
        ApiClient $apiClient,
        HelperData $helperData,
        RequestInterface $request
    ) {
        $this->apiClient = $apiClient;
        $this->helperData = $helperData;
        $this->request = $request;
    }

    /**
     * Execute observer
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(
        \Magento\Framework\Event\Observer $observer
    ) {
        if(!$this->helperData->isModuleEnabled()){
            return $this;
        }

        $this->helperData->logDebug("START - Newsletter Subscriber SaveAfter Observer");

        try {
            //esce se non sono state fatte modifiche
            if(!$observer->getSubscriber()->hasDataChanges()) {
                $this->helperData->logDebug("--- No data changes");
                $this->helperData->logDebug("END - Newsletter Subscriber SaveAfter Observer");
                return $this;
            }

            $subscriber = $observer->getSubscriber();

            //lista di tutti i subject con la stessa email, il valore viene aggiornato per tutti
            $list = $this->apiClient->listSubjectsByEmail($subscriber->getEmail());
            $this->helperData->logDebug("--- subject list: " . print_r($list, true));
            foreach ($list as $subject) {
                //aggiorno i campi di tutti i subject in modo che siano allineati
                $this->apiClient->updateSubjectFromSubscriber($subscriber, $subject["id"]);
                //crea o aggiorna i consensi nell'archivio Iubenda Consents
                $this->apiClient->createNewsletterConsent($subscriber, $subject["id"]);
            }

        } catch (Exception $ex) {
            $this->helperData->log("--- Newsletter Subscriber SaveAfter observer");
            $this->helperData->log("--- error: " . $ex->getMessage());
        }

        $this->helperData->logDebug("END - Newsletter Subscriber SaveAfter Observer");
        return $this;
    }
}

