<?php
declare(strict_types=1);

namespace Drop\IubendaConsentSolution\Observer\Customer;

use Drop\IubendaConsentSolution\Helper\Data as HelperData;
use Drop\IubendaConsentSolution\Model\Api\Client as ApiClient;
use Magento\Customer\Model\Session;
use Magento\Framework\App\RequestInterface;

class SaveAfter implements \Magento\Framework\Event\ObserverInterface {
    /**
     * @var ApiClient
     */
    protected $apiClient;

    /**
     * @var HelperData
     */
    protected $helperData;

    /**
     * @var RequestInterface
     */
    protected $request;

    /**
     * @var Session
     */
    protected $customerSession;

    /**
     * @param ApiClient $apiClient
     * @param HelperData $helperData
     * @param RequestInterface $request
     * @param Session $customerSession
     */
    public function __construct(
        ApiClient $apiClient,
        HelperData $helperData,
        RequestInterface $request,
        Session $customerSession
    ) {
        $this->apiClient = $apiClient;
        $this->helperData = $helperData;
        $this->request = $request;
        $this->customerSession = $customerSession;
    }

    /**
     * Execute observer
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(
        \Magento\Framework\Event\Observer $observer
    ) {
        if(!$this->helperData->isModuleEnabled()){
            return $this;
        }

        $this->helperData->logDebug("START - Customer SaveAfter Observer");

        try {
            //Session flag per impedire l'esecuzione dell'observer 2 volte, alla creazione dell'utente
            //avviene un salvataggio addizionale in createPostAction() - maledetti
            if($this->customerSession->getIubendaCustomerSaveAfterObserverExecuted()){
                //Reset flag per successivi salvataggi
                $this->customerSession->setIubendaCustomerSaveAfterObserverExecuted(false);
                //this method has already been executed once in this request (see comment below)
                $this->helperData->logDebug("--- getIubendaCustomerSaveAfterObserverExecuted = true");
                $this->helperData->logDebug("END - Customer SaveAfter Observer");
                return $this;
            }

            $customer = $observer->getCustomer();
            //crea o aggiorna i consensi nell'archivio Iubenda Consents
            $this->apiClient->createConsent($customer);

            //Customer Addresses seem to call the before_save event twice,
            //so we need to set a variable so we only process it once, otherwise we get duplicates
            $this->customerSession->setIubendaCustomerSaveAfterObserverExecuted(true);
        } catch (Exception $ex) {
            $this->helperData->log("--- Customer SaveAfter observer");
            $this->helperData->log("--- error: " . $ex->getMessage());
        }

        $this->helperData->logDebug("END - Customer SaveAfter Observer");
        return $this;
    }
}

