<?php
declare(strict_types=1);

namespace Drop\IubendaConsentSolution\Helper;

use Drop\IubendaConsentSolution\Api\ConfigPathInterface;
use Drop\IubendaConsentSolution\Logger\Logger;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Store\Model\ScopeInterface;

class Data extends AbstractHelper implements ConfigPathInterface {
    /**
     * @var Logger
     */
    protected $logger;

    /**
     * @param Context $context
     * @param Logger $logger
     */
    public function __construct(
        Context $context,
        Logger $logger
    ) {
        $this->logger = $logger;

        parent::__construct($context);
    }

    /**
     * Returns if the module is enabled
     *
     * @return bool
     */
    public function isModuleEnabled(): bool {
        return boolval($this->getConfigValue(
            self::ENABLED_CONFIG_PATH
        ));
    }

    /**
     * Returns if the debug mode is enabled
     *
     * @return bool
     */
    public function isDebugModeEnabled(): bool {
        return boolval($this->scopeConfig->isSetFlag(
            self::DEBUG_MODE_CONFIG_PATH,
            ScopeInterface::SCOPE_WEBSITE
        ));
    }

    /**
     * Returns the config value based on the selected environment
     *
     * @param string $path
     * @return mixed
     */
    public function getConfigValue(string $path) {
        return $this->scopeConfig->getValue(
            $path,
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Log message only if debug mode is enabled
     *
     * @param string $message
     * @return bool
     */
    public function logDebug(string $message): bool {
        if ($this->isDebugModeEnabled()) {
            //Using info instead of debug method because not working properly
            return $this->logger->info($message);
        }
        return false;
    }

    /**
     * Log message based on the level
     *
     * @param string $message
     * @param int $level
     * @return bool
     */
    public function log(string $message, int $level): bool {
        return $this->logger->log($level, $message);
    }

    /**
     * Return ip address
     *
     * @return false|string
     */
    public function getRemoteAddress() {
        return $this->_remoteAddress->getRemoteAddress();
    }
}

