<?php

/*
 * Description: Data.php
 * @date: 18-mag-2018
 * @author Simone Monterubbiano <s.monterubbiano@drop.it>
 */
namespace Drop\Import\Helper\System;

class Category extends \Drop\Import\Helper\Data implements SystemInterface {
    
    const XML_PATH_CATEGORY_BEHAVIOR            = 'dropimport/category/behavior';
    const XML_PATH_CATEGORY_VALIDATION_STRATEGY = 'dropimport/category/validation_strategy';
    const XML_PATH_CATEGORY_ALLOWED_ERROR_COUNT = 'dropimport/category/allowed_error_count';
    const XML_PATH_CATEGORY_IMPORT_METHOD = 'dropimport/category/import_method';
    const XML_PATH_CATEGORY_IMPORT_PATH_URL = 'dropimport/category/import_path_url';
    const XML_PATH_CATEGORY_IGNORE_DUPLICATES = 'dropimport/category/ignore_duplicates';
    
    const ENTITY_CODE = 'catalog_category';
    
    /**
     * Get Behavior
     * 
     * @return string
     */
    public function getBehavior()
    {
        return $this->getScopeConfig(self::XML_PATH_CATEGORY_BEHAVIOR);
    }

    /**
     * Get Validation Strategy
     * 
     * @return string
     */
    public function getValidationStrategy()
    {
        return $this->getScopeConfig(self::XML_PATH_CATEGORY_VALIDATION_STRATEGY);
    }

    /**
     * Get Allowed Error Count
     * 
     * @return int
     */
    public function getAllowedErrorCount()
    {
        return $this->getScopeConfig(self::XML_PATH_CATEGORY_ALLOWED_ERROR_COUNT);
    }

    /**
     * Get Import Method
     * 
     * @return int
     */
    public function getImportMethod()
    {
        return $this->getScopeConfig(self::XML_PATH_CATEGORY_IMPORT_METHOD);
    }

    /**
     * Get Import Path or Url
     * 
     * @return int
     */
    public function getImportPathUrl()
    {
        return $this->getScopeConfig(self::XML_PATH_CATEGORY_IMPORT_PATH_URL);
    }

    /**
     * Get Ignore Duplicates
     * 
     * @return bool
     */
    public function getIgnoreDuplicates()
    {
        return (bool) $this->getScopeConfig(self::XML_PATH_CATEGORY_IGNORE_DUPLICATES);
    }    

    /**
     * Get Entity Code
     * 
     * @return bool
     */
    public function getEntityCode()
    {
        return self::ENTITY_CODE;
    }    
       
}
