<?php

/*
 * Description: Data.php
 * @date: 18-mag-2018
 * @author Simone Monterubbiano <s.monterubbiano@drop.it>
 */
namespace Drop\Import\Helper;

class Data extends \Magento\Framework\App\Helper\AbstractHelper{
    
    /**
     * \Magento\Framework\App\Config\ScopeConfigInterface
     * 
     * @var type 
     */
    protected $_config;
    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;
    /**
     * @var \Magento\Customer\Model\ResourceModel\Group\CollectionFactory
     */
    private $customerGroupFactory;

    /**
     * Data constructor.
     * @param \Magento\Framework\App\Helper\Context $context
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Magento\Customer\Model\ResourceModel\Group\CollectionFactory $customerGroupFactory
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Customer\Model\ResourceModel\Group\CollectionFactory $customerGroupFactory
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->storeManager                = $storeManager;
        $this->customerGroupFactory = $customerGroupFactory;
    }
    
    /**
     * Get object manager
     *
     * @return \Magento\Framework\App\ObjectManager
     */
    public function getObjectManager()
    {
        return \Magento\Framework\App\ObjectManager::getInstance();
    }    
    
    /**
     * Get system product helper
     *
     * @return \Drop\Import\Helper\System\Product
     */    
    public function getSystemProductHelper() {
        return $this->getObjectManager()->get(\Drop\Import\Helper\System\Product::class);
    }
    
    /**
     * Get system category helper
     *
     * @return \Drop\Import\Helper\System\Category
     */    
    public function getSystemCategoryHelper() {
        return $this->getObjectManager()->get(\Drop\Import\Helper\System\Category::class);
    }
    
    /**
     * Get system stock helper
     *
     * @return \Drop\Import\Helper\System\Stock
     */    
    public function getSystemStockHelper() {
        return $this->getObjectManager()->get(\Drop\Import\Helper\System\Stock::class);
    }
    
    /**
     * Retrieve scope config data
     *
     * @param $path
     * @param string $scopeType
     * @param null $scopeCode
     * @return string
     */
    public function getScopeConfig(
        $path,
        $scopeType = \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
        $scopeCode = null
    ) {
        return $this->scopeConfig->getValue($path, $scopeType, $scopeCode);
    }        
    
    /**
     * Retrieve file extesion
     * 
     * @param type $fileName
     * @return string
     */
    public function getFileExtension($fileName) {
        return substr(strrchr($fileName, '.'), 1);
    }
    
    /**
     * Get store code of field name
     * Example: categoria_it return it
     * @todo check if $currentStoreCode exist as a store code
     * @param type $fieldName
     * @return type
     */
    public function getStoreCodeFromFieldName($fieldName) {
        if(strrpos($fieldName, '_') !== false) {
            $codeString = substr($fieldName, strrpos($fieldName, '_') + 1);
            return ($this->getStoreExistByCode($codeString)) ? $codeString : false;
        }

    }
    
    /**
     * Get Store Id By Code
     * @param type $storeCode
     * @return int
     */
    public function getStoreExistByCode($storeCode) {
        $stores = $this->getAllStores();
        foreach($stores as $store) {
            if($store->getCode() === $storeCode) {
                return true;
            }
        }
        return false;
    }

    /**
     * Get base website id
     * @return mixed
     */
    public function getBaseWebsiteId() {
        $websites = $this->getAllWebsites();
        foreach ($websites as $website) {
            //If base already exist return 'base'
            if($website->getCode() == 'base') {
                return $website->getWebsiteId();
            }
        }
        //If base doesn't exist return the first
        foreach ($websites as $website) {
            return $website->getWebsiteId();
        }
    }

    /**
     * Get base website code
     * @return mixed
     */
    public function getBaseWebsiteCode() {
        $websites = $this->getAllWebsites();
        foreach ($websites as $website) {
            //If base already exist return 'base'
            if($website->getCode() == 'base') {
                return $website->getCode();
            }
        }
        //If base doesn't exist return the first
        foreach ($websites as $website) {
            return $website->getCode();
        }
    }

    /**
     * Get default store id
     * @return mixed
     */
    public function getDefaultStoreId() {
        $stores = $this->getAllStores();
        foreach ($stores as $store) {
            //If $store already exist return 'default'
            if($store->getCode() == 'default') {
                return $store->getStoreId();
            }
        }
        //If default doesn't exist return the first
        foreach ($stores as $store) {
            return $store->getStoreId();
        }
    }

    /**
     * Get default store code
     * @return mixed
     */
    public function getDefaultStoreCode() {
        $stores = $this->getAllStores();
        foreach ($stores as $store) {
            //If $store already exist return 'default'
            if($store->getCode() == 'default') {
                return $store->getCode();
            }
        }
        //If default doesn't exist return the first
        foreach ($stores as $store) {
            return $store->getCode();
        }
    }

    /**
     * Get default store label
     * @return mixed
     */
    public function getDefaultStoreLabel() {
        $stores = $this->getAllStores();
        foreach ($stores as $store) {
            //If $store already exist return 'Default Store View'
            if($store->getName() == 'Default Store View') {
                return $store->getName();
            }
        }
        //If default doesn't exist return the first
        foreach ($stores as $store) {
            return $store->getName();
        }
    }

    /**
     * Get customer General group id
     * @return mixed
     */
    public function getGeneralGroupId() {
        $customerGroups = $this->getAllCustomerGroups();
        foreach($customerGroups as $customerGroupFactory) {
            //General group need to exist
            if($customerGroup['label'] == 'General') {
                return $customerGroup['value'];
            }
        }
        //If General group cannot be found return expected id
        return 1;
    }

    public function getAllStores() {
        return $this->storeManager->getStores(true, false);
    }
    public function getAllWebsites() {
        return $this->storeManager->getWebsites();
    }
    public function getAllCustomerGroups() {
        return $this->customerGroupFactory->create()->toOptionArray();
    }

}
