<?php
/**
 * Downloadable
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Products\Updates;

use Magento\Framework\App\ObjectManagerFactory;

class Related extends \Drop\Import\Console\Command\Import\Products
{

    /**
     * Product Helper: \Drop\Import\Helper\System\Product
     * @var type
     */
    private $helper;

    const DEFAULT_DIVIDER = ',';


    public function __construct(
        ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\Import\Logger\Logger $logger,
        \Magento\Framework\App\State $state,
        \Drop\Import\Helper\System\Product $helper
    )
    {
        $this->helper = $helper;
        parent::__construct($objectManagerFactory, $csvProcessor, $logger, $state);
    }

    protected function configure()
    {
        $this->setName('drop:import:related')
            ->setDescription('Import Related Products');

        parent::configure();
    }

    protected function getEntities()
    {
        $this->setEntityCode($this->helper->getEntityCode());
        $this->setBehavior($this->helper->getBehavior());
        $this->setValidationStrategy($this->helper->getValidationStrategy());
        $this->setAllowedErrorCount($this->helper->getAllowedErrorCount());
        $this->setIgnoreDuplicates($this->helper->getIgnoreDuplicates());
        
        $importMethod = $this->helper->getImportMethod();
        if ($importMethod != \Drop\Import\Model\Config\Source\ImportMethod::IMPORT_METHOD_LOCAL_FILE_PATH) {
            //Download file
            die('TODO');
        }

        $fileName = $this->helper->getRelatedImportPathUrl();
        $csvIterationObject = $this->readCSV(BP . '/' . $fileName);

        $products = [];
        $i = 0;
        foreach ($csvIterationObject as $row) {
            if(empty($row['sku'])) {
                echo PHP_EOL . "SKU was not found. Skipping.";
                continue;
            }
            if(empty($row['related_skus']) && empty($row['crosssell_skus']) && empty($row['upsell_skus'])) {
                echo PHP_EOL . "RELATED SKUS was not found. Skipping.";
                continue;
            }

            $row['sku'] = strtolower($row['sku']);
            //TODO: Check if product exist
            $products[$i] = [
                'sku' => $row['sku']
            ];

            //TODO: Check if all related products exist
            if(!empty($row['related_skus'])) {
                $position = '';
                $positionLimit = substr_count($row['related_skus'], self::DEFAULT_DIVIDER) + 1;
                for($positionCounter = 1; $positionCounter<=$positionLimit; $positionCounter++) {
                    $position .= $positionCounter . ',';
                }
                $products[$i] = array_merge($products[$i], [
                    'related_skus' => strtolower($row['related_skus']),
                    'related_position' => rtrim($position, ',')
                ]);
            }
            if(!empty($row['crosssell_skus'])) {
                $position = '';
                $positionLimit = substr_count($row['crosssell_skus'], self::DEFAULT_DIVIDER) + 1;
                for($positionCounter = 1; $positionCounter<=$positionLimit; $positionCounter++) {
                    $position .= $positionCounter . ',';
                }
                $products[$i] = array_merge($products[$i], [
                    'crosssell_skus' => strtolower($row['crosssell_skus']),
                    'crosssell_position' => rtrim($position, ',')
                ]);
            }
            if(!empty($row['upsell_skus'])) {
                $position = '';
                $positionLimit = substr_count($row['upsell_skus'], self::DEFAULT_DIVIDER) + 1;
                for($positionCounter = 1; $positionCounter<=$positionLimit; $positionCounter++) {
                    $position .= $positionCounter . ',';
                }
                $products[$i] = array_merge($products[$i], [
                    'upsell_skus' => strtolower($row['upsell_skus']),
                    'upsell_position' => rtrim($position, ',')
                ]);
            }

            $i++;
        }

//        echo "<br/><pre>";
//        print_r($products);
//        echo "</pre><br/>";
//        die('<br/>' . __METHOD__ . '1');

        return $products;

    }

}
