<?php

namespace Drop\Import\Console\Command\Import;

use Magento\Catalog\Model\Product;
use Magento\Catalog\Model\ProductType;
use Magento\Framework\App\ObjectManagerFactory;
use Drop\Import\Console\Command\AbstractImportCommand;
use Drop\Import\Model\Attribute;
use Magento\Framework\Exception\NoSuchEntityException;

class Prices extends Products
{
    /**
     * Category Helper: \Drop\Import\Helper\System\Product
     * @var type
     */
    private $helper;
    /**
     * Attribute
     * @var type
     */
    private $attribute;
    /**
     * \Magento\Catalog\Api\ProductRepositoryInterface
     * @var type
     */
    private $productRepository;

    public function __construct(
        ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\Import\Logger\Logger $logger,
        \Magento\Framework\App\State $state,
        \Drop\Import\Helper\System\Product $helper,
        Attribute $attribute,
        \Magento\Catalog\Api\ProductRepositoryInterface\Proxy $productRepository
    )
    {
        $this->helper = $helper;
        $this->attribute = $attribute;
        $this->productRepository = $productRepository;
        parent::__construct($objectManagerFactory, $csvProcessor, $logger, $state);
    }

    protected function configure()
    {
        $this->setName('drop:import:prices')->setDescription('Import Products Prices');
        $this->setEntityCode($this->helper->getEntityCode());
        $this->setBehavior($this->helper->getBehavior());
        $this->setValidationStrategy($this->helper->getValidationStrategy());
        $this->setAllowedErrorCount($this->helper->getAllowedErrorCount());
        $this->setIgnoreDuplicates($this->helper->getIgnoreDuplicates());
        parent::configure();
    }

    /**
     * SAMPLES:
     * $products [] = array(
     * 'sku' => "SIMPLE-RED-MIDDLE",
     * 'price' => '1.0000',
     * );
     * @return array
     */
    protected function getEntities()
    {


        $importMethod = $this->helper->getImportMethod();
        if ($importMethod != \Drop\Import\Model\Config\Source\ImportMethod::IMPORT_METHOD_LOCAL_FILE_PATH) {
            //Download file
            die('TODO');
        }

        $fileName = $this->helper->getPriceImportPathUrl();
        $csvIterationObject = $this->readCSV(BP . '/' . $fileName);
        $header = $this->getCsvHeader();
        $languages = $this->getLanguages();
        $products = [];
        $i = 0;
        // Controllo codifica file
        foreach ($header as $headValue) {
            if (mb_detect_encoding($headValue, mb_detect_order(), TRUE) != "ASCII") {
                echo "-ATTENTIONE- controlla la codifica del file csv, dev'essere ASCII";
            }
        }
        foreach ($csvIterationObject as $row) {
            if (empty($row['sku'])) {
                echo PHP_EOL . "SKU was not found. Skipping.";
                continue;
            }
            $row['sku'] = strtolower($row['sku']);
            if (strrpos($row['sku'], '-') !== false) {
                $row['sku'] = substr($row['sku'], 0, strrpos($row['sku'], '-'));
            }
            try {
                $_product = $this->productRepository->get($row['sku']);
            } catch (NoSuchEntityException $e) {
                echo PHP_EOL . strtoupper($row['sku']) . ' NoSuchEntityException on Other Attributes: ' . $e->getMessage() . '. Skipping.';
                continue;
            } catch (\Exception $e) {
                echo PHP_EOL . strtoupper($row['sku']) . ' Exception on Other Attributes: ' . $e->getMessage() . '. Skipping.';
                continue;
            }

            $_arrayOfProducts = array();
            if ($_product) {
                if ($_product->getTypeId() === \Magento\Catalog\Model\Product\Type::TYPE_SIMPLE) {
                    array_push($_arrayOfProducts, $_product);
                } else {
                    $_arrayOfProducts = $this->getSimpleAssociated($_product);
                }
            }

            foreach ($_arrayOfProducts as $simpleProduct) {

                $simpleSku = $simpleProduct->getSku();

                $products[$i] = [
                    'sku' => $simpleSku,
                    'price' => $this->helper->cleanPriceString($row['prezzo'])
                ];

                //Translation rows
                if ($translations = $this->getLanguagesVariables($simpleSku, $languages, $row, $i)) {
                    foreach ($translations as $translation) {
                        array_push($products, $translation);
                        $i++;
                    }
                }

                $i++;
            }

//                if($configurableVisibility = $this->getUpdatedConfigurableVisibility($row, $i)){
//                    $products[$i] = $configurableVisibility;
//                    $i++;
//                }


        }

//        echo "<br/><pre>";
//        print_r($products);
//        echo "<pre><br/>";
//        die(__METHOD__ . '1');

        return $products;
    }

    /**
     * @param $simpleSku
     * @param $languages
     * @param $row
     * @param $i
     * @return array
     */
    public function getLanguagesVariables($simpleSku, $languages, $row, $i)
    {
        $products = [];
        $langCounter = 0;
        foreach ($languages as $lang) {
            if ($lang == self::DEFAULT_STORE) {
                continue;
            }
            $i++;
            $products[$i] = [
                'sku' => $simpleSku,
                'store_view_code' => $lang,
                'price' => $this->helper->cleanPriceString($row['prezzo_' . $lang])
            ];
            $langCounter++;
        }

        return $products;
    }

    /**
     * @param $row
     * @param $i
     * @return mixed
     */
    public function getUpdatedConfigurableVisibility($row, $i)
    {
        $products = [
            'sku' => $row['sku'],
            'visibility' => 'Catalog, Search'
        ];

        return $products;
    }
}
