<?php

namespace Drop\Import\Console\Command\Import;

use Magento\Framework\App\ObjectManagerFactory;
use Drop\Import\Console\Command\AbstractImportCommand;

class Category extends AbstractImportCommand
{
    /**
     * Category Helper: \Drop\Import\Helper\System\Category
     * @var type 
     */
    private $helper;

    const CATEGORY_DELIMITER = '/';
    
    public function __construct(
        ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\Import\Logger\Logger $logger,
        \Magento\Framework\App\State $state,
        \Drop\Import\Helper\System\Category $helper
    )
    {
        $this->helper = $helper;
        parent::__construct($objectManagerFactory, $csvProcessor, $logger, $state);
    }    

    protected function configure()
    {
        $this->setName('drop:import:category')
            ->setDescription('Import Category');

        parent::configure();
    }

    /**
     * SAMPLE:
     * $data[] = array(
            '_root' => 'Default Category',
            '_category' => 'FireGento TestCategory DE',
            'description' => 'Test2',
            'is_active' => '1',
            'include_in_menu' => '1',
            'meta_description' => 'Meta Test',
            'available_sort_by' => 'position',
            'default_sort_by' => 'position',
            'is_anchor' => '1'
        );
        $data[] = array(
            '_store' => 'en',
            'name' => 'FireGento TestCategory EN',
            'description' => 'StoreViewLevel'
        );
     * 
     * @return array
     */
    protected function getEntities()
    {
        $this->setEntityCode($this->helper->getEntityCode());
        $this->setBehavior($this->helper->getBehavior());
        $this->setValidationStrategy($this->helper->getValidationStrategy());
        $this->setAllowedErrorCount($this->helper->getAllowedErrorCount());
        $this->setIgnoreDuplicates($this->helper->getIgnoreDuplicates());
        
        $importMethod = $this->helper->getImportMethod();
        if($importMethod != \Drop\Import\Model\Config\Source\ImportMethod::IMPORT_METHOD_LOCAL_FILE_PATH) {
            //Download file
            die('TODO');
        }
        
        $fileName = $this->helper->getImportPathUrl();
        $csvIterationObject = $this->readCSV(BP . '/' . $fileName);

        /**
         * Attenzione: sembra essere già presente su Firegento la possibilità di inserire una serie di categorie alberate.
         * Sta in Stores -> Configuration -> Services -> FastSimpleImport 2 -> Category path seperator
         * Utilizzare quello invece che la costante definita sopra self::CATEGORY_DELIMITER
         *
         * Manca anche il settaggio dell'url della categoria. Controllare che non ci sia un campo dedicato per settarlo in fase di importazione
         */

        $data = [];
        $categoryTree = [];
        $i = 0;
        foreach($csvIterationObject as $row) {
            foreach($row as $storeCode => $categoryTreeString) {

                $parentCategoryName = 'Default Category';
                $categoryTreeArray = explode(self::CATEGORY_DELIMITER, $categoryTreeString);

                foreach($categoryTreeArray as $categoryName) {

                    if(array_key_exists($categoryName, $categoryTree)) {
                        $parentCategoryName = $categoryName;
                        continue;
                    }

                    $currentStoreCode = $this->helper->getStoreCodeFromFieldName($storeCode);
                    if($currentStoreCode == self::DEFAULT_STORE) {
                        //All Store Views category import
                        //Quando vai ad aggiornare le categorie non riesce più a trovare il path e dà Root category non valido (quelle con Default Category vanno invece)
                        //Testare se invece magari mettendo Default Category/Clothing riesce a prenderlo)
                        $data[$i]['_root'] = $parentCategoryName;
                        $data[$i]['_category'] = $categoryName;
            //            $data[$i]['description'] = $row['categoria'];
            //            $data[$i]['meta_description'] = $row['categoria'];
                        $data[$i]['is_active'] = '1';
                        $data[$i]['include_in_menu'] = '1';
                        $data[$i]['available_sort_by'] = 'position';
                        $data[$i]['default_sort_by'] = 'position';
                        $data[$i]['is_anchor'] = '1';
                        //Trovare metodo Magento per rimuovere caratteri e mettere trattini a posto degli spazi. Da solo non lo fa
                        //Assolutamente da fare altrimenti Magento non crea gli url rewrite e le cattegorie non funzionano
//                        $data[$i]['url_key'] = $categoryName;
                        $i++;

                        $categoryTree[$categoryName] = 1;

                        continue;
                    }

                    //Store category translation
                    $data[$i]['_store'] = $currentStoreCode;
                    $data[$i]['name'] = basename($categoryName);
                    $i++;

                    $categoryTree[$categoryName] = 1;
                }
            }
        }

        echo "<br/><pre>";
        print_r($categoryTree);
        echo "</pre><br/>";
        echo "<br/><pre>";
        print_r($data);
        echo "</pre><br/>";
        die('<br/>TODO: url_key');

        return $data;
    }

}



