<?php

namespace Drop\Import\Console\Command\Import;

use Magento\Framework\App\ObjectManagerFactory;
use Drop\Import\Console\Command\AbstractImportCommand;

class Stock extends AbstractImportCommand
{
    private $helper = null;
    
    public function __construct(
        ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\Import\Logger\Logger $logger,
        \Magento\Framework\App\State $state,
        \Drop\Import\Helper\System\Stock $helper
    ){
        $this->helper = $helper;
        parent::__construct($objectManagerFactory, $csvProcessor, $logger, $state);
    }    
    

    protected function configure()
    {
        $this->setName('drop:import:stock')
            ->setDescription('Import Stock');
        $this->setEntityCode($this->helper->getEntityCode());
        $this->setBehavior($this->helper->getBehavior());
        $this->setValidationStrategy($this->helper->getValidationStrategy());
        $this->setAllowedErrorCount($this->helper->getAllowedErrorCount());
        $this->setIgnoreDuplicates($this->helper->getIgnoreDuplicates());
        parent::configure();
    }

    /*
     *
     * @return array
     */
    protected function getEntities()
    {
        die(__METHOD__);
    }
}
