<?php

namespace Drop\Import\Console\Command\Import;

use Magento\Framework\App\ObjectManagerFactory;
use Drop\Import\Console\Command\AbstractImportCommand;
use Magento\Framework\Exception\NoSuchEntityException;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Input\InputInterface;

class SpecialPrices extends Products
{

    const CLEAN_PARAMETER = 'clean';

    /**
     * Category Helper: \Drop\Import\Helper\System\Product
     * @var type
     */
    private $helper;
    /**
     * Attribute
     * @var type
     */
    private $attribute;
    /**
     * \Magento\Catalog\Api\ProductRepositoryInterface
     * @var type
     */
    private $productRepository;

    public function __construct(
        ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\Import\Logger\Logger $logger,
        \Magento\Framework\App\State $state,
        \Drop\Import\Helper\System\Product $helper,
        \Drop\Import\Model\AttributeFactory $attribute,
        \Magento\Catalog\Api\ProductRepositoryInterface\Proxy $productRepository
    )
    {
        $this->helper = $helper;
        $this->attribute = $attribute;
        $this->productRepository = $productRepository;
        parent::__construct($objectManagerFactory, $csvProcessor, $logger, $state);
    }

    protected function configure()
    {
        $options = [
            new InputOption(
                self::CLEAN_PARAMETER,
                null,
                InputOption::VALUE_NONE,
                'clean special prices'
            )
        ];

        $this->setName('drop:import:special_prices')
            ->setDescription('Import Products Special Prices')
            ->setDefinition($options);

        parent::configure();
    }

    /**
     * SAMPLES:
     * $products [] = array(
     * 'sku' => "SIMPLE-RED-MIDDLE",
     * 'price' => '1.0000',
     * );
     * @return array
     */
    protected function getEntities($option = null)
    {
        //die('<br/>' . __METHOD__ . '1');
        $this->setEntityCode($this->helper->getEntityCode());
        $this->setBehavior($this->helper->getBehavior());
        $this->setValidationStrategy($this->helper->getValidationStrategy());
        $this->setAllowedErrorCount($this->helper->getAllowedErrorCount());
        $this->setIgnoreDuplicates($this->helper->getIgnoreDuplicates());
        $optionArgument = $this->getOptionsArgument();

        $importMethod = $this->helper->getImportMethod();
        if ($importMethod != \Drop\Import\Model\Config\Source\ImportMethod::IMPORT_METHOD_LOCAL_FILE_PATH) {
            //Download file
            die('TODO');
        }


        $fileName = 'pub/media/import/catalog_special_price.csv';
        $csvIterationObject = $this->readCSV(BP . '/' . $fileName);
        $header = $this->getCsvHeader();
        $languages = $this->getLanguages();

        if (isset($optionArgument[self::CLEAN_PARAMETER])) {
            /** @var ResourceConnection $resources */
            $resources = $this->getConnectionPull();

            /** @var AdapterInterface $connection */
            $connection = $resources->getConnection();

            $tableDecimal = $resources->getTableName('catalog_product_entity_decimal');
            $tableDate = $resources->getTableName('catalog_product_entity_datetime');

            $eavModelSP = $this->objectManager->create('Magento\Catalog\Model\ResourceModel\Eav\Attribute');
            $eavModelSF = $this->objectManager->create('Magento\Catalog\Model\ResourceModel\Eav\Attribute');
            $eavModelST = $this->objectManager->create('Magento\Catalog\Model\ResourceModel\Eav\Attribute');
            $specialPrice = $eavModelSP->load(78);
            $specialFromDate = $eavModelSF->load(79);
            $specialToDate = $eavModelST->load(80);
            $specialPriceCode = $specialPrice->getAttributeCode();
            $specialFromDateCode = $specialFromDate->getAttributeCode();
            $specialToDateCode = $specialToDate->getAttributeCode();
            //controllo se gli id 78,79,80 sono gli attributi special
            if ($specialPriceCode == 'special_price' && $specialFromDateCode == 'special_from_date' && $specialToDateCode == 'special_to_date') {
                $specialPriceId = $specialPrice->getAttributeId();
                $specialFromDateId = $specialFromDate->getAttributeId();
                $specialToDateId = $specialToDate->getAttributeId();
            } else {
                die("Gli attributi special_xx non corrispondono, controllare sul codice che gli id siano corretti");
            }
        }
        $products = [];
        $i = 0;
        $this->clearCache(["collections"]);
        foreach ($csvIterationObject as $row) {
            if (empty($row['sku'])) {
                echo PHP_EOL . "SKU was not found. Skipping.";
                continue;
            }

            if (strpos($row['sku'], '-') !== false) {
                $row['colore'] = strtolower(substr($row['sku'], (strrpos($row['sku'], '-') + 1)));
                $row['sku'] = strtolower(substr($row['sku'], 0, strrpos($row['sku'], '-')));
            }

            try {
                $_product = $this->productRepository->get($row['sku']);
            } catch (NoSuchEntityException $e) {
                echo PHP_EOL . strtoupper($row['sku']) . ' NoSuchEntityException on Other Attributes: ' . $e->getMessage() . '. Skipping.';
                continue;
            } catch (\Exception $e) {
                echo PHP_EOL . strtoupper($row['sku']) . ' Exception on Other Attributes: ' . $e->getMessage() . '. Skipping.';
                continue;
            }

            if ($_product && !empty($simpleAssociated = $this->getSimpleAssociated($_product))) {
                foreach ($simpleAssociated as $simpleProduct) {

                    $simpleSku = $simpleProduct->getSku();
                    $simpleId = $simpleProduct->getId();

                    // se uso --clean pulisco i prezzi e le date inizio/fine special_price
                    if (isset($optionArgument[self::CLEAN_PARAMETER])) {

                        echo "clean special price to sku " . $simpleSku . PHP_EOL;
                        try {
                            $connection->delete($tableDecimal, "entity_id = " . $simpleId . " AND attribute_id = " . $specialPriceId);
                            $connection->delete($tableDate, "entity_id = " . $simpleId . " AND attribute_id = " . $specialFromDateId);
                            $connection->delete($tableDate, "entity_id = " . $simpleId . " AND attribute_id = " . $specialToDateId);
                        } catch (Exception $e) {
                            echo $e->getMessage();
                            die("STOP");
                        }

                        // passo un array vuoto per non tornare errore undefined offset
                        $products[$i] = [
                            'sku'               => $simpleSku,
                            'special_price'     => '',
                            'special_from_date' => '',
                            'special_to_date'   => ''
                        ];
                        $i++;

                    } else {

                        if (empty($row['colore']) || (!empty($row['colore']) && strpos($simpleSku, '-' . $row['colore'] . '-') !== false)) {
                            echo "set special_price to sku " . $simpleSku . " " . $this->helper->cleanPriceString($row['special_price']) . PHP_EOL;
                            $products[$i] = [
                                'sku'               => $simpleSku,
                                'special_price'     => $this->helper->cleanPriceString($row['special_price']),
                                'special_from_date' => '', //data inizio, formato '2019-12-31'
                                'special_to_date'   => '' //data fine, formato '2019-12-31'
                            ];
                            $i++;
                        }

                        //Translation rows
                        $langCounter = 0;
                        foreach ($languages as $lang) {
                            $i++;
                            $products[$i] = [
                                'sku'               => $simpleSku,
                                'store_view_code'   => $lang,
                                'special_price'     => $this->helper->cleanPriceString($row['special_price_' . $lang]),
                                'special_from_date' => '', //data inizio, formato '2019-12-31'
                                'special_to_date'   => '' //data fine, formato '2019-12-31'
                            ];
                            $langCounter++;
                        }
                    }

                }
            }
        }

        //Bisognerebbe aggiungere un controllo sull'array dei prodotti che fa un check sulla consecutività delle chiavi
        //Se le chiavi non sono perfettamente consecutive, non carica tutti i prodotti ma si ferma a quel numero
//        echo PHP_EOL . count($products);
//        echo PHP_EOL . '<pre>';
//        print_r($products);
//        echo '</pre>' . PHP_EOL;
//        die(__METHOD__ . '1');

        return $products;
    }

}
