<?php

/*
 * Description: Stock.php
 * @date: 23-mag-2018
 * @author Simone Monterubbiano <s.monterubbiano@drop.it>
 */
namespace Drop\Import\Model\Import;

use Magento\CatalogInventory\Model\Stock as StockModel;

class Stock extends \Magento\ImportExport\Model\Import\AbstractEntity {
    
    public function __construct(
            \Magento\Framework\Stdlib\StringUtils $string, 
            \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig, 
            \Magento\ImportExport\Model\ImportFactory $importFactory, 
            \Magento\ImportExport\Model\ResourceModel\Helper $resourceHelper, 
            \Magento\Framework\App\ResourceConnection $resource, 
            \Magento\ImportExport\Model\Import\ErrorProcessing\ProcessingErrorAggregatorInterface $errorAggregator, 
            array $data = array()) {
        parent::__construct(
                $string, 
                $scopeConfig, 
                $importFactory, 
                $resourceHelper, 
                $resource, 
                $errorAggregator, 
                $data);
    }


    /**
     * Create Category entity from raw data.
     *
     * @throws \Exception
     * @return bool Result of operation.
     */
    protected function _importData()
    {
        die(__METHOD__);
        if (Import::BEHAVIOR_DELETE == $this->getBehavior()) {
            $this->deleteCategories();
        } else {
            $this->saveCategories();
            $this->saveOnTab();
        }

        //$this->reindexImportedCategories();

        $this->eventManager->dispatch('catalog_category_import_finish_before', ['adapter' => $this]);

        return true;
    }
    
    /**
     * EAV entity type code getter.
     *
     * @abstract
     * @return string
     */
    public function getEntityTypeCode(){
        return StockModel::ENTITY;
    }
    
    /**
     * Validate data row.
     *
     * @param array $rowData
     * @param int $rowNum
     * @return boolean
     */
    public function validateRow(array $rowData, $rowNum){
        return true;
    }
    
    /**
     * Set valid attribute set and category type to rows with all scopes
     * to ensure that existing Categories doesn't changed.
     *
     * @param array $rowData
     * @return array
     */
    protected function _prepareRowForDb(array $rowData){
        die(__METHOD__);
    }
    
}