<?php

/*
 * Description: Data.php
 * @date: 18-mag-2018
 * @author Simone Monterubbiano <s.monterubbiano@drop.it>
 */
namespace Drop\Import\Helper\System;

class Stock extends \Drop\Import\Helper\Data implements SystemInterface {
    
    const XML_PATH_STOCK_BEHAVIOR            = 'dropimport/stock/behavior';
    const XML_PATH_STOCK_VALIDATION_STRATEGY = 'dropimport/stock/validation_strategy';
    const XML_PATH_STOCK_ALLOWED_ERROR_COUNT = 'dropimport/stock/allowed_error_count';
    const XML_PATH_STOCK_IMPORT_METHOD = 'dropimport/stock/import_method';
    const XML_PATH_STOCK_IMPORT_PATH_URL = 'dropimport/stock/import_path_url';
    const XML_PATH_STOCK_IMPORT_IMAGES_FILE_DIR = 'dropimport/stock/import_images_file_dir';
    const XML_PATH_STOCK_IGNORE_DUPLICATES = 'dropimport/stock/ignore_duplicates';
    
    
    //const ENTITY_CODE = 'cataloginventory_stock';
    const ENTITY_CODE = 'catalog_product';
    
    //Da utilizzare, messi solo perchè altrimenti da errore
    /**
     * Get Behavior
     * 
     * @return string
     */
    public function getBehavior()
    {
        return $this->getScopeConfig(self::XML_PATH_STOCK_BEHAVIOR);
    }

    /**
     * Get Validation Strategy
     * 
     * @return string
     */
    public function getValidationStrategy()
    {
        return $this->getScopeConfig(self::XML_PATH_STOCK_VALIDATION_STRATEGY);
    }

    /**
     * Get Allowed Error Count
     * 
     * @return int
     */
    public function getAllowedErrorCount()
    {
        return $this->getScopeConfig(self::XML_PATH_STOCK_ALLOWED_ERROR_COUNT);
    }

    /**
     * Get Allowed Error Count
     * 
     * @return int
     */
    public function getImportMethod()
    {
        return $this->getScopeConfig(self::XML_PATH_STOCK_IMPORT_METHOD);
    }

    /**
     * Get Allowed Error Count
     * 
     * @return int
     */
    public function getImportPathUrl()
    {
        return $this->getScopeConfig(self::XML_PATH_STOCK_IMPORT_PATH_URL);
    }

    /**
     * Get Ignore Duplicates
     * 
     * @return bool
     */
    public function getIgnoreDuplicates()
    {
        return (bool) $this->getScopeConfig(self::XML_PATH_STOCK_IGNORE_DUPLICATES);
    }    

    /**
     * Get Entity Code
     * 
     * @return bool
     */
    public function getEntityCode()
    {
        return self::ENTITY_CODE;
    }        
       
}