<?php

/*
 * Description: Data.php
 * @date: 18-mag-2018
 * @author Simone Monterubbiano <s.monterubbiano@drop.it>
 */
namespace Drop\Import\Helper\System;

class Attribute extends \Drop\Import\Helper\Data implements SystemInterface {
    
    const XML_PATH_ATTRIBUTE_BEHAVIOR            = 'dropimport/attribute/behavior';
    const XML_PATH_ATTRIBUTE_VALIDATION_STRATEGY = 'dropimport/attribute/validation_strategy';
    const XML_PATH_ATTRIBUTE_ALLOWED_ERROR_COUNT = 'dropimport/attribute/allowed_error_count';
    const XML_PATH_ATTRIBUTE_IMPORT_METHOD = 'dropimport/attribute/import_method';
    const XML_PATH_ATTRIBUTE_IMPORT_PATH_URL = 'dropimport/attribute/import_path_url';
    const XML_PATH_ATTRIBUTE_IGNORE_DUPLICATES = 'dropimport/attribute/ignore_duplicates';  
    
    const ENTITY_CODE = 'catalog_attribute';
    
    /**
     * Get Behavior
     * 
     * @return string
     */
    public function getBehavior()
    {
        return $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_BEHAVIOR);
    }

    /**
     * Get Validation Strategy
     * 
     * @return string
     */
    public function getValidationStrategy()
    {
        return $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_VALIDATION_STRATEGY);
    }

    /**
     * Get Allowed Error Count
     * 
     * @return int
     */
    public function getAllowedErrorCount()
    {
        return $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_ALLOWED_ERROR_COUNT);
    }

    /**
     * Get Import Method
     * 
     * @return int
     */
    public function getImportMethod()
    {
        return $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_IMPORT_METHOD);
    }

    /**
     * Get Import Path or Url
     * 
     * @return int
     */
    public function getImportPathUrl()
    {
        return $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_IMPORT_PATH_URL);
    }

    /**
     * Get Ignore Duplicates
     * 
     * @return bool
     */
    public function getIgnoreDuplicates()
    {
        return (bool) $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_IGNORE_DUPLICATES);
    }    

    /**
     * Get Entity Code
     * 
     * @return bool
     */
    public function getEntityCode()
    {
        return self::ENTITY_CODE;
    }    
       
}