<?php
/**
 * Copyright © 2015 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Drop\Import\Model\Config\Source;
use \Magento\ImportExport\Model\Import\ErrorProcessing\ProcessingErrorAggregatorInterface;
class ImportMethod implements \Magento\Framework\Option\ArrayInterface
{
    
    const IMPORT_METHOD_LOCAL_FILE_PATH = 'local-file-path';
    const IMPORT_METHOD_DOWNLOAD_HTTP = 'download-http';
    
    /**
     * Options array
     *
     * @var array
     */
    protected $_options;

    /**
     * Return options array
     *
     * @return array
     */
    public function toOptionArray()
    {
        if (!$this->_options) {
            $this->_options = [
                ['value' => self::IMPORT_METHOD_LOCAL_FILE_PATH, 'label' => __('Local file path')], 
                ['value' => self::IMPORT_METHOD_DOWNLOAD_HTTP, 'label' => __('Download from remote http url')], 
            ];
        }

        return $this->_options;
    }
}
