<?php
/**
 * Downloadable
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Products\Updates;

use Magento\Framework\App\ObjectManagerFactory;
use Magento\Framework\Exception\NoSuchEntityException;

class Images extends \Drop\Import\Console\Command\Import\Products
{

    /**
     * Product Helper: \Drop\Import\Helper\System\Product
     * @var type
     */
    private $helper;

    const IMAGES_COUNTER_SEPARATOR = '_';
    //TODO: Dynamic
    const IMAGES_FORMAT = '.jpg';

    public function __construct(
        ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\Import\Logger\Logger $logger,
        \Magento\Framework\App\State $state,
        \Drop\Import\Helper\System\Product $helper,
        \Magento\Catalog\Api\ProductRepositoryInterface\Proxy $productRepository,
        \Magento\Framework\App\Filesystem\DirectoryList $directoryList
    )
    {
        $this->helper = $helper;
        $this->productRepository = $productRepository;
        $this->directoryList = $directoryList;
        parent::__construct($objectManagerFactory, $csvProcessor, $logger, $state);
    }

    protected function configure()
    {
        $this->setName('drop:import:images')
            ->setDescription('Import Images Products');

        parent::configure();
    }

    protected function getEntities()
    {
        $this->setEntityCode($this->helper->getEntityCode());
        $this->setBehavior($this->helper->getBehavior());
        $this->setValidationStrategy($this->helper->getValidationStrategy());
        $this->setAllowedErrorCount($this->helper->getAllowedErrorCount());
        $this->setIgnoreDuplicates($this->helper->getIgnoreDuplicates());

        $importMethod = $this->helper->getImportMethod();
        if ($importMethod != \Drop\Import\Model\Config\Source\ImportMethod::IMPORT_METHOD_LOCAL_FILE_PATH) {
            //Download file
            die('TODO');
        }

        $fileName = $this->helper->getImportPathUrl();
        $csvIterationObject = $this->readCSV(BP . '/' . $fileName);

        $products = [];
        $i = -1;
        foreach ($csvIterationObject as $row) {
            if(empty($row['sku'])) {
                echo PHP_EOL . "SKU was not found. Skipping.";
                continue;
            }

            $row['sku'] = strtolower($row['sku']);

            try {
                $product = $this->productRepository->get($row['sku']);
            } catch (NoSuchEntityException $e) {
                echo PHP_EOL . strtoupper($row['sku']) . ' NoSuchEntityException on Other Attributes: ' . $e->getMessage() . '. Skipping.';
                continue;
            } catch (\Exception $e) {
                echo PHP_EOL . strtoupper($row['sku']) . ' Exception on Other Attributes: ' . $e->getMessage() . '. Skipping.';
                continue;
            }

            // Images
            $imagesAbsolutePath = $this->directoryList->getPath('media') . '/import/images/';
            $imagesRelativePath = 'images/';
            $configurableImages = [];
            for($imagesCounter=1; $imagesCounter<10; $imagesCounter++) {
                $imageName = strtoupper($row['sku']) . self::IMAGES_COUNTER_SEPARATOR . '0' . $imagesCounter . self::IMAGES_FORMAT;
                if(file_exists($imagesAbsolutePath . $imageName)) {
                    if(!isset($configurableImages['additional_images'])) {
                        $configurableImages['additional_images'] = $imagesRelativePath . $imageName;
                    } else {
                        $configurableImages['additional_images'] .= ',' . $imagesRelativePath . $imageName;
                    }
                    foreach($this->getImageRoleKey($imagesCounter) as $imageRole) {
                        $configurableImages[$imageRole] = $imagesRelativePath . $imageName;
                    }
                }
            }

            if(!empty($configurableImages)) {
                $i++;
                $products[$i] = array_merge([
                    'sku' => $row['sku'],
                    'status' => \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED
                ], $configurableImages);
            }

            if($product->getTypeId()=="configurable"):
                $simpleProducts = $this->getSimpleAssociated($product);

                foreach($simpleProducts as $simpleProduct) {

                    $simpleSku = $simpleProduct->getSku();

                    //Swatches Images
                    $simpleImages = [];
                    for($imagesCounter=1; $imagesCounter<10; $imagesCounter++) {
                        //Image name is sku without size part (-42)
                        $imageName = strtoupper(substr($simpleSku, 0, strrpos($simpleSku, '-'))) . self::IMAGES_COUNTER_SEPARATOR . '0' . $imagesCounter . self::IMAGES_FORMAT;
                        if(file_exists($imagesAbsolutePath . $imageName)) {
                            if(!isset($simpleImages['additional_images'])) {
                                $simpleImages['additional_images'] = $imagesRelativePath . $imageName;
                            } else {
                                $simpleImages['additional_images'] .= ',' . $imagesRelativePath . $imageName;
                            }
                            foreach($this->getImageRoleKey($imagesCounter) as $imageRole) {
    //                            echo PHP_EOL . 'SIMPLE' . $simpleSku . ' - ' . $imageRole . ': ' . $imagesRelativePath . $imageName;
                                $simpleImages[$imageRole] = $imagesRelativePath . $imageName;
                            }
                        }
                    }


                    if(!empty($simpleImages) && !empty($simpleSku)) {
                        $i++;
                        $products[$i] = array_merge([
                            'sku' => $simpleSku,
                            'status' => \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED
                        ], $simpleImages);
                    }

                }
            endif;
        }

//        echo "<br/><pre>";
//        print_r($products);
//        echo "</pre><br/>";
//        die('<br/>' . __METHOD__ . '1');

        return $products;

    }

    /**
     * @param $i
     * @return string
     */
    public function getImageRoleKey($i) {
        switch ($i) {
            case 1:
                return ['base_image','small_image','thumbnail_image'];
            case 2:
                return ['hover_image'];
        }
        return [];
    }

}
