<?php
/**
 * Bundle
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Products;

use Magento\Framework\App\ObjectManagerFactory;

class Bundle extends \Drop\Import\Console\Command\Import\Products
{

    /**
     * Product Helper: \Drop\Import\Helper\System\Product
     * @var type
     */
    private $helper;


    public function __construct(
        ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\Import\Logger\Logger $logger,
        \Magento\Framework\App\State $state,
        \Drop\Import\Helper\System\Product $helper
    )
    {
        $this->helper = $helper;
        parent::__construct($objectManagerFactory, $csvProcessor, $logger, $state);
    }

    protected function configure()
    {
        $this->setName('drop:import:bundle')
            ->setDescription('Import Bundle Products');
        
        parent::configure();
    }

    protected function getEntities()
    {
        $this->setEntityCode($this->helper->getEntityCode());
        $this->setBehavior($this->helper->getBehavior());
        $this->setValidationStrategy($this->helper->getValidationStrategy());
        $this->setAllowedErrorCount($this->helper->getAllowedErrorCount());
        $this->setIgnoreDuplicates($this->helper->getIgnoreDuplicates());
        $this->setImportImagesFileDir($this->helper->getImportImagesFileDir());
        die('<br/>' . __METHOD__ . '1');
    }

    /**
     * Import Bundles sample function
     */
//    protected function getEntities()
//    {
//        $simpleProducts = [];
//        $bundleProduct = array(
//            'sku' => 'Bundle-Product',
//            'attribute_set_code' => 'Default',
//            'product_type' => 'bundle',
//            'product_websites' => 'base',
//            'name' => 'FireGento Test Product Bundle',
//            'price' => '10.000',
//
//            'bundle_price_type' => 'dynamic',
//            'bundle_sku_type' => 'dynamic',
//            'bundle_price_view' => 'Price range',
//            'bundle_weight_type' => 'dynamic',
//        );
//
//        $colors = array("blue", "black");
//        $bundleValues = '';
//        for ($i = 0; $i < 2; $i++) {
//
//            $color = $colors[$i];
//            $sku = 'SIMPLE-' . $color;
//            $simpleProducts[] = array(
//                'sku' => $sku,
//                'attribute_set_code' => 'Default',
//                'product_type' => 'simple',
//                'product_websites' => 'base',
//                'name' => 'FireGento Test Product Simple - ' . $color,
//                'price' => '14.0000',
//                'additional_attributes' => "color=" . $color
//
//            );
//            $bundleAttributes = array(
//                "name" => "Color",
//                "type" => 'radio',
//                'required' => '1',
//                'sku' => $sku,
//                'price' => '14.0000',
//                'default' => $i,
//                'default_qty' => '1.0000',
//                'price_type' => 'fixed'
//            );
//
//            $bundleValues .= $this->arrayToAttributeString($bundleAttributes) . "|";
//
//        }
//        $bundleProduct["bundle_values"] = $bundleValues;
//        print_r($bundleProduct);
//
//        $data = array_merge($simpleProducts, array($bundleProduct));
//
//        return $data;
//    }

}
