<?php
/**
 * Downloadable
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Customer;

use Magento\Backend\App\Area\FrontNameResolver;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Magento\Framework\Exception\AlreadyExistsException;

use Magento\Framework\App\ObjectManagerFactory;
use Magento\Store\Model\StoreManager;
use Magento\Store\Model\Store;

class Newsletter extends Command
{
    /**
     * @var \Magento\Framework\File\Csv
     */
    private $csvProcessor;
    /**
     * Object manager factory
     *
     * @var ObjectManagerFactory
     */
    private $objectManagerFactory;
    /**
     * @var \Magento\Framework\ObjectManagerInterface
     */
    protected $objectManager;

    /**
     * @var \Magento\Customer\Model\CustomerFactory
     */
    private $customerFactory;
    /**
     * @var Magento\Newsletter\Model\SubscriberFactory
     */
    private $subscriberFactory;

    const FILE_PATH = 'pub/media/import/customer_all.csv';
    /**
     * @var \Magento\Framework\App\State
     */
    private $state;
    /**
     * @var \Magento\Framework\ObjectManager\ConfigLoaderInterface
     */
    private $configLoader;
    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $_storeManager;

    /**
     * Urlrewrite constructor.
     * @param \Magento\Framework\App\State $state
     * @param \Magento\Framework\ObjectManager\ConfigLoaderInterface $configLoader
     */
    public function __construct(
        \Magento\Framework\App\State $state,
        \Magento\Framework\ObjectManager\ConfigLoaderInterface $configLoader,
        \Magento\Framework\File\Csv $csvProcessor,
        \Magento\Customer\Model\CustomerFactory $customerFactory,
        \Magento\Newsletter\Model\SubscriberFactory $subscriberFactory,
        \Magento\Store\Model\StoreManagerInterface $storeManager
    )
    {
        $this->state = $state;
        $this->configLoader = $configLoader;
        $this->csvProcessor = $csvProcessor;
        $this->customerFactory = $customerFactory;
        $this->subscriberFactory = $subscriberFactory;
        $this->_storeManager = $storeManager;

        parent::__construct();
    }

    protected function configure()
    {
        $this->setName('drop:import:newsletter_subscriber')
            ->setDescription('Import Newsletter Subscriber');
    }

    /**
     * Send last changed subscribers to Sendinblue
     * @return $this
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function execute(InputInterface $input, OutputInterface $output) {
        try {
            // this tosses an error if the areacode is not set.
            $this->state->getAreaCode();
        } catch (\Exception $e) {
            $this->state->setAreaCode('adminhtml');
        }
        
        $data = $this->csvProcessor->getData(BP . '/' . self::FILE_PATH);
        $header = array_shift($data);

        $i = 0;
        $customers = [];
        foreach ($data as $row) {
            foreach ($row as $key => $value) {
                $customers[$i][$header[$key]] = $value;
            }
            $i++;
        }

        $i = 0;
        $successCounter = 0;
        $errorCounter = 0;
        $missingData = 0;
        foreach($customers as $customer) {

            $notFound = false;
/*            if(($customer['newsletter'] == 'FALSE') || empty($customer['email'])) {
                $missingData++;
                continue;
            }*/

            //TEST
//            if($i == 5) {
//                break;
//            }
//            $i++;

            $customerEx = $this->customerFactory->create()->loadByEmail($customer['email']);
            if (!$customerEx->getId()) {
                echo PHP_EOL . "Customer " . $customer['email'] . " doesn't exist";
                $notFound = true;
                //continue;
            }

            /** @var \Magento\Newsletter\Model\Subscriber $subscriberModel */
            $subscriberModel = $this->subscriberFactory->create();
            $subscriber = $subscriberModel->loadByEmail($customer['email']);
            if($subscriber->isSubscribed()) {
                echo PHP_EOL . "Customer " . $customer['email'] . " is already subscribed to newsletter";
                continue;
            }
            switch ($customer['store']) {
                case "IT":
                    $storeId = 1;
                    break;
                case "EU":
                    $storeId = 3;
                    break;
                case "WW":
                    $storeId = 6;
                    break;
                default:
                    $storeId = 0;
                    break;
            }

            try {
                $successCounter++;
                if($notFound){
                    //echo "ok".$customer['email'];
                    $this->_storeManager->setCurrentStore($storeId);
                    $subscriberModel->subscribe($customer['email']);
                } else {
                    $subscriberModel->subscribeCustomerById($customer->getId());
                }
                echo PHP_EOL . 'Subscribed customer: ' . $customer['email'];
//                if($successCounter == 1) {
//                    break;
//                }
            } catch (\Exception $e) {
                echo PHP_EOL . $e->getMessage();
                $errorCounter++;
                continue;
            }
        }

        echo PHP_EOL;
        echo PHP_EOL . "Imported successfully " . $successCounter . ' newsletter subscriber';
        echo PHP_EOL . "NOT IMPORTED " . $errorCounter . ' newsletter subscriber';
        echo PHP_EOL;
    }

}
