<?php

namespace Drop\Import\Console\Command\Import;

use Magento\Framework\App\ObjectManagerFactory;
use Drop\Import\Console\Command\AbstractImportCommand;

class AttributesSet extends AbstractImportCommand
{
    /**
     * Category Helper: \Drop\Import\Helper\System\Product
     * @var type 
     */
    private $helper;
    
    public function __construct(
        ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\Import\Logger\Logger $logger,
        \Magento\Framework\App\State $state,
        \Drop\Import\Helper\System\AttributeSet $helper
    )
    {
        $this->helper = $helper;
        parent::__construct($objectManagerFactory, $csvProcessor, $logger, $state);
    }    

    protected function configure()
    {
        $this->setName('drop:import:attributeset')
            ->setDescription('Import Attribute Sets');

        parent::configure();
    }

    /**
     * @return array
     */
    protected function getEntities()
    {
        $this->setEntityCode($this->helper->getEntityCode());
        $this->setBehavior($this->helper->getBehavior());
        $this->setValidationStrategy($this->helper->getValidationStrategy());
        $this->setAllowedErrorCount($this->helper->getAllowedErrorCount());
        $this->setIgnoreDuplicates($this->helper->getIgnoreDuplicates());
        
        $importMethod = $this->helper->getImportMethod();
        if($importMethod != \Drop\Import\Model\Config\Source\ImportMethod::IMPORT_METHOD_LOCAL_FILE_PATH) {
            //Download file
            die('TODO');
        }

        $fileName = $this->helper->getImportPathUrl();
        $csvIterationObject = $this->readCSV(BP . '/' . $fileName);
        $languages = $this->getLanguages();

        $data = [];
        $i = 0;
        foreach($csvIterationObject as $row) {

            //Label options and tralsations
            //Lammerda per fare contento Giordano che vuole le colonne al posto delle righe per le traduzioni
            //Cmq da rifare, l'ho fatto troppo veloce, fa schifo
            if(empty($row['codice'])) {
                $data[$i-$langCounter-1]['option_value'] .= '|' . $row['taglia'];
                $asdCounter = 0;
                foreach($languages as $lang) {
                    if(!empty($row['taglia_' . $lang])) {
                        $data[$i-$langCounter+$asdCounter]['option_value'] .= '|' . $row['taglia_' . $lang];
                    }
                    $asdCounter++;
                }
                continue;
            }

            //Base row
            $data[$i] = array(
                'attribute_set_name' => $row['codice'],
                'attribute_code' => $row['codice'],
                'frontend_label' => $row['scaletaglie_' . self::DEFAULT_STORE],
                'option_store' => '',
                'option_value' => $row['taglia']
            );

            //Translation rows
            $langCounter = 0;
            foreach($languages as $lang) {
                $i++;
                $data[$i] = array(
                    'attribute_set_name' => $row['codice'],
                    'attribute_code' => $row['codice'],
                    'frontend_label' => $row['scaletaglie_' . $lang],
                    'option_store' => $lang,
                    'option_value' => $row['taglia_' . $lang]
                );
                $langCounter++;
            }

            $i++;
        }

//        echo "<pre>";
//        print_r($data);
//        echo "</pre>";
//        die(__METHOD__ . '1');

        return $data;
    }
    
}
