<?php
/**
 * Grouped
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Products;

use Magento\Framework\App\ObjectManagerFactory;

class Grouped extends \Drop\Import\Console\Command\Import\Products
{

    /**
     * Product Helper: \Drop\Import\Helper\System\Product
     * @var type
     */
    private $helper;


    public function __construct(
        ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\Import\Logger\Logger $logger,
        \Magento\Framework\App\State $state,
        \Drop\Import\Helper\System\Product $helper
    )
    {
        $this->helper = $helper;
        parent::__construct($objectManagerFactory, $csvProcessor, $logger, $state);
    }

    protected function configure()
    {
        $this->setName('drop:import:grouped')
            ->setDescription('Import Grouped Products');

        parent::configure();
    }

    protected function getEntities()
    {
        $this->setEntityCode($this->helper->getEntityCode());
        $this->setBehavior($this->helper->getBehavior());
        $this->setValidationStrategy($this->helper->getValidationStrategy());
        $this->setAllowedErrorCount($this->helper->getAllowedErrorCount());
        $this->setIgnoreDuplicates($this->helper->getIgnoreDuplicates());
        $this->setImportImagesFileDir($this->helper->getImportImagesFileDir());
        die('<br/>' . __METHOD__ . '1');
    }

}
