<?php

namespace Drop\Import\Console\Command\Import\Customer;

use Magento\Framework\App\ObjectManagerFactory;

class CustomerComposite extends \Drop\Import\Console\Command\Import\Customer
{
    /**
     * Customer Helper: \Drop\Import\Helper\System\Customer
     * @var type 
     */
    private $helper;
    /**
     * @var \Magento\Framework\Stdlib\DateTime\DateTime
     */
    private $date;

//    private $genderConversion;
    public $genderConversion = [
        'Uomo' => 'Male',
        'Donna' => 'Female',
    ];
//    public $useGeocode = 0;
    public $useGeocode = 1;

    /**
     * Customer constructor.
     * @param ObjectManagerFactory $objectManagerFactory
     * @param \Magento\Framework\File\Csv $csvProcessor
     * @param \Drop\Import\Logger\Logger $logger
     * @param \Magento\Framework\App\State $state
     * @param \Drop\Import\Helper\System\Customer $helper
     * @param \Magento\Framework\Stdlib\DateTime\DateTime $date
     * @param \Magento\Framework\DataObjectFactory $dataObjectFactory
     * @param \Magento\Customer\Model\CustomerFactory $customerFactory
     * @param \Magento\Directory\Model\RegionFactory $regionFactory
     */
    public function __construct(
        ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,  
        \Drop\Import\Logger\Logger $logger,
        \Magento\Framework\App\State $state,
        \Drop\Import\Helper\System\Customer $helper,
        \Magento\Framework\Stdlib\DateTime\DateTime\Proxy $date,
        \Magento\Framework\DataObjectFactory $dataObjectFactory,
        \Magento\Customer\Model\CustomerFactory $customerFactory,
        \Magento\Directory\Model\RegionFactory $regionFactory
    )
    {
        $this->helper = $helper;
        $this->date = $date;
        parent::__construct($objectManagerFactory, $csvProcessor, $logger, $state, $helper, $date, $dataObjectFactory, $customerFactory, $regionFactory);
    }

    protected function configure()
    {
        $this->setName('drop:import:customer_composite')
            ->setDescription('Import Customers with Address');

        parent::configure();
    }

    /**
     * SAMPLE:
     * $data[] = array(
            'email' => 'testemail@firegento.de',
            '_website' => 'base',
            '_store' => 'default',
            'confirmation' => '',
            'created_at' => '2015-12-26 18:05:23',
            'created_in' => 'Default Store View',
            'disable_auto_group_change' => '0',
            'dob' => '1973-12-15',
            'firstname' => 'Veronica',
            'gender' => 'Female',
            'group_id' => '1',
            'lastname' => 'Costello',
            'middlename' => '',
            'password_hash' => '',
            'prefix' => '',
            'rp_token' => '',
            'rp_token_created_at' => '',
            'store_id' => '1',
            'suffix' => '',
            'taxvat' => '',
            'updated_at' => '2015-12-26 18:05:23',
            'website_id' => '1',
            'password' => 'TestTest',
        );
     * @return array
     */
    protected function getEntities()
    {
        $this->setEntityCode($this->helper->getCompositeEntityCode());
        $this->setBehavior($this->helper->getBehavior());
        $this->setValidationStrategy($this->helper->getValidationStrategy());
        $this->setAllowedErrorCount($this->helper->getAllowedErrorCount());
        $this->setIgnoreDuplicates($this->helper->getIgnoreDuplicates());
        
        $importMethod = $this->helper->getImportMethod();
        if($importMethod != \Drop\Import\Model\Config\Source\ImportMethod::IMPORT_METHOD_LOCAL_FILE_PATH) {
            //Download file
            die('TODO');
        }
        
        $fileName = $this->helper->getImportPathUrl();
        $csvIterationObject = $this->readCSV(BP . '/' . $fileName);
        
        $data = [];
        $i = 0;
        foreach($csvIterationObject as $row) {
            if(empty($row['email']) || !filter_var($row['email'], FILTER_VALIDATE_EMAIL)) {
                echo PHP_EOL . "Email was empty or invalid. Skipping.";
                continue;
            }
            if(empty($row['nome']) || empty($row['cognome'])) {
                echo PHP_EOL . "Empty name/surname for email: " . $row['email'] . ". Skipping.";
                continue;
            }
            if($this->getIfCustomerExistByEmail($row['email'])) {
                echo PHP_EOL . "Customer " . $row['email'] . ' already exist. Skipping.';
                continue;
            }

            $row['country'] = '';
            $regionId = '';
            if(!empty($row['indirizzo']) && !empty($row['localita']) && !empty($row['cap'])) {
                $address = $this->formatAddress($row);
                $geocodedAddress = $this->geocodeAddress($address);

                if(empty($geocodedAddress) && empty($row['country'])) {
                    echo PHP_EOL . "Empty country from user: " .$row['email'];
                    continue;
                }
                $row['country'] = $geocodedAddress['country'];

                if($this->getRegionExist($geocodedAddress['administrative_area_level_2'],$row['country'])) {
                    $regionId = $geocodedAddress['administrative_area_level_2'];
                } elseif($this->getRegionExist($geocodedAddress['administrative_area_level_1'],$row['country'])) {
                    $regionId = $geocodedAddress['administrative_area_level_1'];
                } else {
                    echo PHP_EOL . "Region " . $geocodedAddress['administrative_area_level_2'] . " or " . $geocodedAddress['administrative_area_level_1'] . " doesn't exist for country " . $row['country'];
                    continue;
                }
            }

            $data[$i] = [
                'email' => $row['email'],
                'firstname' => $row['nome'],
                'lastname' => $row['cognome'],

                '_website' => $this->getWebsiteCode(),
                '_store' => $this->getStoreCode($row['country']),
                'created_in' => $this->getStoreLabel($row['country']),
                'group_id' => $this->getGroupId(),
                'store_id' => $this->getStoreId($row['country']),
                'website_id' => $this->getWebsiteId(),

                'confirmation' => '',
                'disable_auto_group_change' => '0',

                'dob' => $this->dobConversion($row['data_nascita']),
                'gender' => $this->genderConversion($row['sesso']),
                'taxvat' => $row['codice_fiscale'],

                'created_at' => $this->dateConversion($row['data_registrazione']),
                'updated_at' => $date = $this->date->gmtDate(),

                'ip_address' => 'Imported customer from old website',
                'is_privacy_policy_accepted' => 'Yes',
                'is_profiling_accepted' => 'No'

//                'middlename' => '',
//                'password_hash' => '',
//                'prefix' => '',
//                'rp_token' => '',
//                'rp_token_created_at' => '',
//                'suffix' => '',
//                'password' => ''
            ];

            if($row['newsletter'] == 'TRUE') {
                $data[$i] = array_merge($data[$i], [
                    'is_profiling_accepted' => 'Yes'
                ]);
            } else {
                $data[$i] = array_merge($data[$i], [
                    'is_profiling_accepted' => 'No'
                ]);
            }

            $addressFound = false;
            if($this->useGeocode && $this->geocodeModuleExist() && !empty($geocodedAddress)) {
                $geocodedRoute = $geocodedAddress['route'];
                if(!empty($geocodedAddress['route']) && !empty($geocodedAddress['street_number'])) {
                    $geocodedRoute = $geocodedAddress['route'] . ', ' . $geocodedAddress['street_number'];
                }

                $data[$i] = array_merge($data[$i], [
                    '_address_city' => $geocodedAddress['locality'],
                    '_address_country_id' => $geocodedAddress['country'],
                    '_address_postcode' => $geocodedAddress['postal_code'],
                    '_address_region' => $regionId,
                    '_address_street' => $geocodedRoute
                ]);

                $addressFound = true;
            } else {
                if(!empty($row['indirizzo']) &&!empty($row['localita']) && !empty($row['country']) && !empty($row['cap']) && !empty($row['provincia'])) {
                    $data[$i] = array_merge($data[$i], [
                        '_address_city' => $row['localita'],
                        '_address_country_id' => $row['country'],
                        '_address_postcode' => $row['cap'],
                        '_address_region' => $row['provincia'], //check existance
                        '_address_street' => $row['indirizzo'],
                    ]);
                    $addressFound = true;
                }
            }

            if(!$addressFound) {
                unset($data[$i]);
                //Magento 2 on customer_composite import does not permit to import customer without address :(
                continue;
            }

            if($addressFound && !empty($row['nome']) && !empty($row['cognome']) && !empty($row['telefono'])) {
                $data[$i] = array_merge($data[$i], [
                    '_address_firstname' => $row['nome'],
                    '_address_lastname' => $row['cognome'],
                    '_address_telephone' => $row['telefono'],
                    '_address_vat_id' => $row['codice_fiscale'],
                    '_address_default_billing_' => 1,
                    '_address_default_shipping_' => 1,

//                '_address_company' => $row['cognome'],
//                '_address_fax' => $row['cognome'],
//                '_address_middlename' => $row['cognome'],
//                '_address_prefix' => $row['cognome'],
//                '_address_suffix' => $row['cognome'],
                ]);
            } else {
                unset($data[$i]);
                continue;
            }

            //TODO: newsletter

            $i++;

            //TEST
//            if($i == 5) {
//                break;
//            }
        }

//        echo PHP_EOL . "<pre>";
//        print_r($data);
//        echo "</pre>" . PHP_EOL;
//        die(PHP_EOL . __METHOD__ . '1');

        return $data;
    }

}



