<?php

/*
 * Description: Data.php
 * @date: 18-mag-2018
 * @author Simone Monterubbiano <s.monterubbiano@drop.it>
 */
namespace Drop\Import\Helper\System;

class Product extends \Drop\Import\Helper\Data implements SystemInterface {
    
    const XML_PATH_PRODUCT_BEHAVIOR            = 'dropimport/product/behavior';
    const XML_PATH_PRODUCT_VALIDATION_STRATEGY = 'dropimport/product/validation_strategy';
    const XML_PATH_PRODUCT_ALLOWED_ERROR_COUNT = 'dropimport/product/allowed_error_count';
    const XML_PATH_PRODUCT_IMPORT_METHOD = 'dropimport/product/import_method';
    const XML_PATH_PRODUCT_IMPORT_PATH_URL = 'dropimport/product/import_path_url';
    const XML_PATH_PRODUCT_IMPORT_IMAGES_FILE_DIR = 'dropimport/product/import_images_file_dir';
    const XML_PATH_PRODUCT_IGNORE_DUPLICATES = 'dropimport/product/ignore_duplicates';    
    const XML_PATH_PRODUCT_PRICE_IMPORT_PATH_URL = 'dropimport/product/price_import_path_url';
    const XML_PATH_PRODUCT_GROUP_PRICE_IMPORT_PATH_URL = 'dropimport/product/group_price_import_path_url';
    const XML_PATH_PRODUCT_RELATED_IMPORT_PATH_URL = 'dropimport/product/related_import_path_url';

    const ENTITY_CODE = 'catalog_product';
    
    /**
     * Get Behavior
     * 
     * @return string
     */
    public function getBehavior()
    {
        return $this->getScopeConfig(self::XML_PATH_PRODUCT_BEHAVIOR);
    }

    /**
     * Get Validation Strategy
     * 
     * @return string
     */
    public function getValidationStrategy()
    {
        return $this->getScopeConfig(self::XML_PATH_PRODUCT_VALIDATION_STRATEGY);
    }

    /**
     * Get Allowed Error Count
     * 
     * @return int
     */
    public function getAllowedErrorCount()
    {
        return $this->getScopeConfig(self::XML_PATH_PRODUCT_ALLOWED_ERROR_COUNT);
    }

    /**
     * Get Allowed Error Count
     * 
     * @return int
     */
    public function getImportMethod()
    {
        return $this->getScopeConfig(self::XML_PATH_PRODUCT_IMPORT_METHOD);
    }

    /**
     * Get Allowed Error Count
     * 
     * @return int
     */
    public function getImportPathUrl()
    {
        return $this->getScopeConfig(self::XML_PATH_PRODUCT_IMPORT_PATH_URL);
    }

    /**
     * Get Import Images File Dir
     * 
     * @return string
     */
    public function getImportImagesFileDir()
    {
        return $this->getScopeConfig(self::XML_PATH_PRODUCT_IMPORT_IMAGES_FILE_DIR);
    }

    /**
     * Get Ignore Duplicates
     * 
     * @return bool
     */
    public function getIgnoreDuplicates()
    {
        return (bool) $this->getScopeConfig(self::XML_PATH_PRODUCT_IGNORE_DUPLICATES);
    }    

    /**
     * Get Entity Code
     * 
     * @return bool
     */
    public function getEntityCode()
    {
        return self::ENTITY_CODE;
    }

    /**
     * Get Price CSV File path
     *
     * @return int
     */
    public function getPriceImportPathUrl()
    {
        return $this->getScopeConfig(self::XML_PATH_PRODUCT_PRICE_IMPORT_PATH_URL);
    }

    /**
     * Get Price CSV File path
     *
     * @return int
     */
    public function getGroupPriceImportPathUrl()
    {
        return $this->getScopeConfig(self::XML_PATH_PRODUCT_GROUP_PRICE_IMPORT_PATH_URL);
    }

    /**
     * Get Related CSV File path
     *
     * @return int
     */
    public function getRelatedImportPathUrl()
    {
        return $this->getScopeConfig(self::XML_PATH_PRODUCT_RELATED_IMPORT_PATH_URL);
    }

    /**
     * Convert all strings formats to Magento price
     * @return float
     */
    public function cleanPriceString($price) {
        // convert "," to "."
        $price = str_replace(',', '.', $price);

        // remove everything except numbers and dot "."
        $price = preg_replace("/[^0-9\.]/", "", $price);

        //Convert to 4 digits
        $price = number_format((float) $price, 4);

        return $price;
    }
       
}
