<?php
/**
 * Downloadable
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Products\Updates;

use Magento\Framework\App\ObjectManagerFactory;
use Magento\Framework\Exception\NoSuchEntityException;

class DisableMissingImages extends \Drop\Import\Console\Command\Import\Products
{

    /**
     * Product Helper: \Drop\Import\Helper\System\Product
     * @var type
     */
    private $helper;
    /**
     * @var Magento\Catalog\Model\ResourceModel\Product\Collection
     */
    private $productCollectionFactory;


    /**
     * Disable constructor.
     * @param ObjectManagerFactory $objectManagerFactory
     * @param \Magento\Framework\File\Csv $csvProcessor
     * @param \Drop\Import\Logger\Logger $logger
     * @param \Drop\Import\Helper\System\Product $helper
     * @param Magento\Catalog\Model\ResourceModel\Product\Collection $productCollectionFactory
     */
    public function __construct(
        ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\Import\Logger\Logger $logger,
        \Magento\Framework\App\State $state,
        \Drop\Import\Helper\System\Product $helper,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory
    )
    {
        $this->helper = $helper;
        $this->productCollectionFactory = $productCollectionFactory;
        parent::__construct($objectManagerFactory, $csvProcessor, $logger, $state);
    }

    protected function configure()
    {
        $this->setName('drop:import:disable_missing_images')
            ->setDescription('Disable products without images');

        parent::configure();
    }

    protected function getEntities()
    {
        $this->setEntityCode($this->helper->getEntityCode());
        $this->setBehavior($this->helper->getBehavior());
        $this->setValidationStrategy($this->helper->getValidationStrategy());
        $this->setAllowedErrorCount($this->helper->getAllowedErrorCount());
        $this->setIgnoreDuplicates($this->helper->getIgnoreDuplicates());
        
        $products = [];

        $collection = $this->productCollectionFactory->create()
                            ->addAttributeToSelect('small_image')
                            ->addAttributeToSelect('hover_image')
                            ->addAttributeToSelect('status')
//                            ->addFieldToFilter('status', array('neq' => \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_DISABLED))
                            ->addAttributeToSort('id')
                            ->setPageSize(99999999999999999999999999999999999999999)
                            ->load();

        //Debug collection
//        echo PHP_EOL . count($collection);
//        echo PHP_EOL;
//        echo PHP_EOL;

        $i = -1;
        foreach($collection as $product) {

            if(($product->getSku() == 'gift-card') || ($product->getSku() == '27ABZ310')) {
                //Skip gift card and bundle product
                continue;
            }

            //Debug id and products inside collection
//            echo PHP_EOL . $product->getId() . ' - ' . $product->getSku();

            if((empty($product->getSmallImage()) || empty($product->getHoverImage()))) {
                if($product->getStatus() == \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED) {
                    //Se manca small_image oppure hover_image ed è abilitato => disabilitare
                    $i++;
                    $products[$i] = [
                        'sku' => $product->getSku(),
                        'product_online' => \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_DISABLED,
                        'status' => \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_DISABLED
                    ];
                }
            } else {
                if($product->getStatus() == \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_DISABLED) {
                    //Se ha entrambe le foto ed è disabilitato
                    $i++;
                    $products[$i] = [
                        'sku' => $product->getSku(),
                        'product_online' => \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED,
                        'status' => \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED
                    ];
                }
            }
        }

//        echo "<br/><pre>";
//        print_r($products);
//        echo "</pre><br/>";
//        die('<br/>' . __METHOD__ . '1');

        return $products;

    }

}
