<?php
/**
 * Downloadable
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Products\Updates;

use Magento\Framework\App\ObjectManagerFactory;
use Magento\Framework\Exception\NoSuchEntityException;

class Disable extends \Drop\Import\Console\Command\Import\Products
{

    /**
     * Product Helper: \Drop\Import\Helper\System\Product
     * @var type
     */
    private $helper;

    const FILE_PATH = 'pub/media/import/catalog_disable.csv';
    /**
     * @var \Magento\Catalog\Api\ProductRepositoryInterface
     */
    private $productRepository;


    /**
     * Disable constructor.
     * @param ObjectManagerFactory $objectManagerFactory
     * @param \Magento\Framework\File\Csv $csvProcessor
     * @param \Drop\Import\Logger\Logger $logger
     * @param \Drop\Import\Helper\System\Product $helper
     * @param \Magento\Catalog\Api\ProductRepositoryInterface $productRepository
     */
    public function __construct(
        ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\Import\Logger\Logger $logger,
        \Drop\Import\Helper\System\Product $helper,
        \Magento\Framework\App\State $state,
        \Magento\Catalog\Api\ProductRepositoryInterface\Proxy $productRepository
    )
    {
        $this->helper = $helper;
        $this->productRepository = $productRepository;
        parent::__construct($objectManagerFactory, $csvProcessor, $logger, $state);
    }

    protected function configure()
    {
        $this->setName('drop:import:disabled')
            ->setDescription('Import Disabled Products');

        parent::configure();
    }

    protected function getEntities()
    {
        $this->setEntityCode($this->helper->getEntityCode());
        $this->setBehavior($this->helper->getBehavior());
        $this->setValidationStrategy($this->helper->getValidationStrategy());
        $this->setAllowedErrorCount($this->helper->getAllowedErrorCount());
        $this->setIgnoreDuplicates($this->helper->getIgnoreDuplicates());

        $csvIterationObject = $this->readCSV(BP . '/' . self::FILE_PATH);

        $products = [];
        $i = -1;
        foreach ($csvIterationObject as $row) {
            if(empty($row['sku'])) {
                echo PHP_EOL . "SKU was not found. Skipping.";
                continue;
            }

            $row['sku'] = strtolower($row['sku']);

            try {
                $product = $this->productRepository->get($row['sku']);
            } catch (NoSuchEntityException $e) {
                echo PHP_EOL . ' NoSuchEntityException for sku ' . strtoupper($row['sku']) . ' - ' . $e->getMessage() . '. Skipping.';
                continue;
            } catch (\Exception $e) {
                echo PHP_EOL . ' Exception for sku ' . strtoupper($row['sku']) . ' - ' . $e->getMessage() . '. Skipping.';
                continue;
            }

            $simpleProducts = $this->getSimpleAssociated($product);
            foreach($simpleProducts as $simpleProduct) {
                if($simpleProduct->getStatus() == \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_DISABLED) {
                    continue;
                }
                $i++;
                $products[$i] = [
                    'sku' => $simpleProduct->getSku(),
                    'status' => \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_DISABLED
                ];
            }

            if($product->getStatus() == \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_DISABLED) {
                continue;
            }

            $i++;
            $products[$i] = [
                'sku' => $row['sku'],
                'status' => \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_DISABLED
            ];

        }

//        echo "<br/><pre>";
//        print_r($products);
//        echo "</pre><br/>";
//        die('<br/>' . __METHOD__ . '1');

        return $products;

    }

}
