<?php
/**
 * Swatches
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Products;

use Magento\Framework\App\ObjectManagerFactory;
use Drop\Import\Model\Attribute;

class Swatches extends \Drop\Import\Console\Command\Import\Products
{
    const IMAGES_COUNTER_SEPARATOR = '_';
    //TODO: Dynamic
    const IMAGES_FORMAT = '.jpg';

    private $configurableSimplesAssociated = [];
    public $setAttributeOnSimpleExcludingFromConfigurable = [

    ];

    /**
     * Product Helper: \Drop\Import\Helper\System\Product
     * @var type
     */
    private $helper;
    /**
     * Attribute
     * @var type
     */
    private $attribute;
    /**
     * @var \Magento\Eav\Api\AttributeSetRepositoryInterface
     */
    private $attributeSet;
    /**
     * @var \Magento\Catalog\Api\ProductRepositoryInterface
     */
    private $productRepository;
    /**
     * @var \Magento\Framework\App\Filesystem\DirectoryList
     */
    private $directoryList;
    /**
     * @var \Magento\Catalog\Model\Product\Url
     */
    private $url;


    public function __construct(
        ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\Import\Logger\Logger $logger,
        \Magento\Framework\App\State $state,
        \Drop\Import\Helper\System\Product $helper,
        Attribute $attribute,
        \Magento\Catalog\Api\ProductRepositoryInterface\Proxy $productRepository,
        \Magento\Catalog\Model\Product\Url $url,
        \Magento\Eav\Api\AttributeSetRepositoryInterface\Proxy $attributeSet,
        \Magento\Framework\App\Filesystem\DirectoryList $directoryList
    )
    {
        $this->helper = $helper;
        $this->attribute = $attribute;
        $this->attributeSet = $attributeSet;
        $this->productRepository = $productRepository;
        $this->directoryList = $directoryList;
        $this->url = $url;
        parent::__construct($objectManagerFactory, $csvProcessor, $logger, $state);
    }

    protected function configure()
    {
        $this->setName('drop:import:swatches')
            ->setDescription('Import Swatches Products');

        $this->setEntityCode($this->helper->getEntityCode());
        $this->setBehavior($this->helper->getBehavior());
        $this->setValidationStrategy($this->helper->getValidationStrategy());
        $this->setAllowedErrorCount($this->helper->getAllowedErrorCount());
        $this->setIgnoreDuplicates($this->helper->getIgnoreDuplicates());
        $this->setImportImagesFileDir($this->helper->getImportImagesFileDir());
        parent::configure();
    }

    protected function getEntities()
    {

        $fileName = $this->helper->getImportPathUrl();
        /**
         * TODO: per farlo funzionare su STD ho sovrascritto la funzione readCSV mettendo come chiave dei vari array lo sku
         */
        $csvIterationObject = $this->readCSV(BP . '/' . $fileName);
        $languages = $this->getLanguages();

        $products = [];
        $i = 0;
        foreach ($csvIterationObject as $row) {

            if (empty($row['sku'])) {
                echo PHP_EOL . "SKU was not found. Skipping.";
                continue;
            }

            $row['sku'] = strtolower($row['sku']);
            $row['attribute_set_code'] = strtolower($row['attribute_set_code']);

            if (empty($row['name_' . self::DEFAULT_STORE])) {
                echo PHP_EOL . "NAME was not found for product: " . strtoupper($row['sku']) . '. Skipping.';
                continue;
            }
            if (empty($row['categories'])) {
                echo PHP_EOL . "CATEGORIES was not found for product: " . strtoupper($row['sku']) . '. Skipping.';
                continue;
            }
            if (empty($row['store'])) {
                echo PHP_EOL . "STORES was not found for product: " . strtoupper($row['sku']) . '. Skipping.';
                continue;
            }

            $websites = $row['store'];
            if (strpos($row['store'], '|') != false) {
                $websites = str_replace('|', ',', $row['store']);
            }

            // Images
            $images = $this->getImages($row['sku']);

            //Images doesn't exist. Skipping product import
            if (empty($images)) {
                echo PHP_EOL . "IMAGE was not found for product: " . strtoupper($row['sku']) . '. Skipping.';
                continue;
            }


            $parentSku = $row['cod_modello'] . $row['cod_materiale'];
            $superAttributeOptions = $this->attribute->getSuperAttributeOptions($row['attribute_set_code']);
            if (isset($this->configurableSimplesAssociated[$parentSku])) {
                $configurableVariations = $this->configurableSimplesAssociated[$parentSku];
            } else {
                $configurableVariations = [];
                // TODO: first configurable variable dinamic
                foreach ($superAttributeOptions['variante_colore'] as $simpleColorOptions):
                    $newSku = $parentSku . $simpleColorOptions['label'];
                    if (!array_key_exists($newSku, $csvIterationObject)) {
                        continue;
                    }
                    foreach ($superAttributeOptions as $superAttributeCode => $simpleOptions):
                        // TODO: first configurable variable dinamic
                        if ($superAttributeCode == 'variante_colore') {
                            continue;
                        }

                        foreach ($simpleOptions as $simpleOption) {
                            if (empty($simpleOption['value']) || trim($simpleOption['label']) === "") {
                                continue;
                            }

                            $Simpleimages = $this->getImages($newSku);
                            if (empty($Simpleimages)) {
                                echo PHP_EOL . "IMAGE was not found for simple product: " . strtoupper($newSku) . '. Skipping.';
                                continue;
                            }

                            $products[$i] = [
                                'sku'                => $newSku . '-' . $simpleOption['label'],
                                'store_view_code'    => '',
                                'attribute_set_code' => $row['attribute_set_code'],
                                'product_type'       => 'simple',
                                'product_websites'   => $websites,
                                'name'               => $csvIterationObject[$newSku]['name_' . self::DEFAULT_STORE] . ' - ' . $row['attribute_set_code'] . ': ' . $simpleOption['label'],
                                $superAttributeCode  => $simpleOption['label'],
                                'color'              => $csvIterationObject[$newSku]['color'],
                                'color_testuale'     => $csvIterationObject[$newSku]['color_testuale_' . self::DEFAULT_STORE],
                                'variante_colore'    => $simpleColorOptions['label'],
                                'categories'         => 'Default Category/' . $row['categories'],
                                'price'              => '0',
                                'weight'             => '1.0000',
                                'visibility'         => 'Not Visible Individually',
                                'status'             => 'Disabled'
                            ];

                            if (!empty($Simpleimages)) {
                                $products[$i] = array_merge($products[$i], $Simpleimages);
                            }

                            $configurableVariations[$i] = [
                                'sku'               => $products[$i]['sku'],
                                $superAttributeCode => $products[$i][$superAttributeCode],
                                'variante_colore'   => $products[$i]['variante_colore']
                            ];

                            $this->configurableSimplesAssociated[$parentSku][] = $configurableVariations[$i];

                            $i++;

                        }
                    endforeach;
                endforeach;
            }

            $products[$i] = [
                'sku'                => $row['sku'],
                'store_view_code'    => '',
                'attribute_set_code' => $row['attribute_set_code'], //TODO: Check if exist
                'product_type'       => 'configurable',
                'product_websites'   => $websites,
                'categories'         => 'Default Category/' . $row['categories'],
                'name'               => $row['name_' . self::DEFAULT_STORE],
                'description'        => $this->convertStringToUtf8($row['description_' . self::DEFAULT_STORE]),
                'price'              => '0',
                'weight'             => '1.0000',
                'color'              => $row['color'],
                'url_key'            => $this->url->formatUrlKey($this->formatProductUrl($row['name_' . self::DEFAULT_STORE] . '-' . $row['sku'])),
                'meta_title'         => $row['name_' . self::DEFAULT_STORE] . ' - ' . $row['sku'],
                'meta_description'   => $this->convertStringToUtf8(substr($row['name_' . self::DEFAULT_STORE] . ' - ' . $row['sku'] . ' - ' . $row['description_' . self::DEFAULT_STORE], 0, 84)),
                'visibility'         => 'Search',
                'status'             => 'Disabled',
                'manage_stock'       => 0
            ];

            if (!empty($images)) {
                $products[$i] = array_merge($products[$i], $images);
            }

            //Other attributes
            $products[$i] = array_merge($products[$i], $this->getConfigurableAttributes($row, self::DEFAULT_STORE));

            //Simple products associated
            foreach ($configurableVariations as $configurableVariation) {
                $products[$i]['configurable_variations'][] = $configurableVariation;
            }

            //Translation rows
            if ($translations = $this->getLanguagesVariables($languages, $row, $i)) {
                foreach ($translations as $translation) {
                    array_push($products, $translation);
                    $i++;
                }
            }

            $i++;
        }

        echo "\n<pre>";
        print_r($products);
        echo "<pre>\n";
        die(__METHOD__ . '1');

        return $products;
    }


    /**
     * @param $i
     * @return string
     */
    public function getImageRoleKey($i)
    {
        switch ($i) {
            case 1:
                return ['base_image', 'small_image', 'thumbnail_image'];
            case 2:
                return ['hover_image'];
        }
        return [];
    }

    /**
     * @param $languages
     * @param $row
     * @param $i
     * @return array
     */
    public function getLanguagesVariables($languages, $row, $i)
    {
        $products = [];
        $langCounter = 0;
        foreach ($languages as $lang) {
            if ($lang == self::DEFAULT_STORE) {
                continue;
            }
            $storeView = ($lang == 'it') ? 'it_it' : '';
            $i++;
            $products[$i] = [
                'sku'                => $row['sku'],
                'product_type'       => 'configurable',
                'store_view_code'    => $storeView,
                'attribute_set_code' => $row['attribute_set_code'], //TODO: Check if exist
                'name'               => $row['name_' . $lang],
                'description'        => $this->convertStringToUtf8($row['description_' . $lang]),
                'url_key'            => $this->url->formatUrlKey($row['name_' . $lang] . '-' . $row['sku']),
                'meta_title'         => $row['name_' . $lang] . ' - ' . $row['sku'],
                'meta_description'   => $this->convertStringToUtf8(substr($row['name_' . $lang] . ' - ' . $row['sku'] . ' - ' . $row['description_' . $lang], 0, 84))
            ];
            //Other attributes
            $products[$i] = array_merge($products[$i], $this->getConfigurableAttributes($row, $lang));
            $langCounter++;
        }

        return $products;
    }

    /**
     * @param $sku
     * @return array
     */
    public function getImages($sku)
    {
        $imagesAbsolutePath = $this->directoryList->getPath('media') . '/import/images/';
        $imagesRelativePath = 'images/';
        $images = [];
        for ($imagesCounter = 1; $imagesCounter < 10; $imagesCounter++) {
            $imageName = strtoupper($sku) . self::IMAGES_COUNTER_SEPARATOR . '0' . $imagesCounter . self::IMAGES_FORMAT;
            if (file_exists($imagesAbsolutePath . $imageName)) {
                if (!isset($images['additional_images'])) {
                    $images['additional_images'] = $imagesRelativePath . $imageName;
                } else {
                    $images['additional_images'] .= ',' . $imagesRelativePath . $imageName;
                }
                foreach ($this->getImageRoleKey($imagesCounter) as $imageRole) {
                    $images[$imageRole] = $imagesRelativePath . $imageName;
                }
            }
        }

        return $images;
    }
}
