<?php

namespace Drop\Import\Console\Command\Import;

use Drop\Import\Console\Command\AbstractImportCommand;

/**
 * TODO: Importare improvement fatti su Doppelganger
 * Class Products
 * @package Drop\Import\Console\Command\Import
 */

class Products extends AbstractImportCommand
{

    /**
     * Ritorna i prodotti semplici associati ad un configurabile
     * @param $configurable
     * @return mixed
     */
    public function getSimpleAssociated($configurable) {
        return $configurable->getTypeInstance()->getUsedProducts($configurable);
    }

    /**
     * Logica del settaggio dei ruoli delle immagini
     * Non modificare quì ma sovrascrivere. E' fatta apposta
     * @param $i
     * @return string
     */
    public function getImageRoleKey($i) {
        switch ($i) {
            case 1:
                return 'base_image';
            case 2:
                return 'small_image';
            case 3:
                return 'thumbnail_image';
        }
        return 'additional_images';
    }

    protected function getEntities()
    {

    }

    /**
     * Utile da prevedere per swatches
     * Se c'è qualche altro caso segnarlo in questo commento
     * Sovrascrivere la variabile $setAttributeOnSimpleExcludingFromConfigurable.
     * @param $field
     * @return bool
     */
    public function setAttributeOnSimpleExcludingFromConfigurable($field) {
        if(in_array($field, $this->setAttributeOnSimpleExcludingFromConfigurable)) {
            return true;
        }
        return false;
    }

    /**
     * TODO: Pensare formattazione url di default
     * Non modificare quì ma sovrascrivere. E' fatta apposta
     * @param $url
     * @return mixed
     */
    public function formatProductUrl($url) {
        return $url;
    }

    /**
     * Method to have secure utf8 string
     * @param $string
     * @return bool|string
     */
    public function convertStringToUtf8($string) {
        $decoded = utf8_decode($string);
        if (mb_detect_encoding($decoded , 'UTF-8', true) === false)
            return $string;
        return $decoded;
    }

}
