<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Model\Formatter;

class Customer extends AbstractFormatter {

    const FIELD_GENDER = 'gender';
    const FIELD_PRIVACY_POLICY = 'privacy_policy';
    const FIELD_PROFILING = 'profiling';
    const FIELD_IP_ADDRESS = 'ip_address';
    const FIELD_TAX_VAT = 'vat_id';

    const FIELD_ADDRESS_STREET = 'street';
    const FIELD_ADDRESS_CITY = 'city';
    const FIELD_ADDRESS_REGION = 'region';
    const FIELD_ADDRESS_POSTCODE = 'postcode';
    const FIELD_ADDRESS_COUNTRY = 'country';

    /**
     * @var \Magento\Framework\DataObjectFactory
     */
    private $dataObjectFactory;
    /**
     * @var \Magento\Framework\App\ObjectManagerFactory
     */
    private $objectManagerFactory;
    /**
     * @var \Drop\Import\Helper\Customer
     */
    private $helper;

    /**
     * Customer constructor.
     * @param \Magento\Framework\App\ObjectManagerFactory $objectManagerFactory
     * @param \Magento\Framework\DataObjectFactory $dataObjectFactory
     * @param \Drop\Import\Helper\Customer $helper
     */
    public function __construct(
        \Magento\Framework\App\ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\DataObjectFactory $dataObjectFactory,
        \Drop\Import\Helper\Customer $helper
    )
    {
        $this->objectManagerFactory = $objectManagerFactory;
        $this->dataObjectFactory = $dataObjectFactory;
        $this->helper = $helper;
    }

    /**
     * @return mixed
     */
    public function genderFormatter() {
        return $this->getRow()[self::FIELD_GENDER];
    }

    /**
     * @return mixed
     */
    public function privacyFormatter() {
        return $this->getRow()[self::FIELD_PRIVACY_POLICY];
    }

    /**
     * @return mixed
     */
    public function profilingFormatter() {
        return $this->getRow()[self::FIELD_PROFILING];
    }

    /**
     * @param $date
     * @return mixed
     */
    public function dateFormatter($date) {
        return $date;
    }

    /**
     * @return mixed
     */
    public function ipAddressFormatter() {
        return $this->getRow()[self::FIELD_IP_ADDRESS];
    }

    /**
     * @param $taxvat
     * @return mixed
     */
    public function taxvatFormatter() {
        return $this->getRow()[self::FIELD_TAX_VAT];
    }

    /**
     * @param $row
     * @return \Magento\Framework\DataObject
     */
    public function addressFormatter() {
        $row = $this->getRow();
        return $this->dataObjectFactory->create()
                        ->setAddress($this->getStringUtf8($row[self::FIELD_ADDRESS_STREET]))
                        ->setCity($this->getStringUtf8($row[self::FIELD_ADDRESS_CITY]))
                        ->setRegion($row[self::FIELD_ADDRESS_REGION])
                        ->setPostcode($row[self::FIELD_ADDRESS_POSTCODE])
                        ->setCountry($row[self::FIELD_ADDRESS_COUNTRY]);
    }

    /**
     * @param \Magento\Framework\DataObject $address
     * @return \Magento\Framework\DataObject
     */
    public function storeAddressFormatter(\Magento\Framework\DataObject $address) {
        if(!$this->helper->geocodeModuleExist()) {
            return $address;
        }

        /** @var \Limesharp\Stockists\Controller\Adminhtml\Stores\Geocode $geocodeController */
        $geocodeController = $this->objectManagerFactory->create()->get('\Limesharp\Stockists\Controller\Adminhtml\Stores\Geocode');
        return $geocodeController->getStoreFormattedAddress($address);
    }

}
