<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Model\Formatter;

class Category extends AbstractFormatter {

    const FIELD_CATEGORY_NAME = 'categoria';
    const FIELD_CATEGORY_DESCRIPTION = 'description';

    const DEFAULT_CATEGORY_IS_ACTIVE = '1';
    const DEFAULT_CATEGORY_INCLUDE_IN_MENU = '1';
    const DEFAULT_CATEGORY_AVAILABLE_SORT_BY = 'position,name,price'; // TODO: Use All
    const DEFAULT_CATEGORY_DEFAULT_SORT_BY = 'position';              // TODO: Use Config Settings
    const DEFAULT_CATEGORY_IS_ANCHOR = '1';

    /**
     * @var \Magento\Catalog\Model\Category
     */
    private $category;

    /**
     * Category constructor.
     * @param \Magento\Catalog\Model\Category $category
     */
    public function __construct(
        \Magento\Catalog\Model\Category $category
    )
    {
        $this->category = $category;
    }

    /**
     * Rewrite this to change url_key
     * @return mixed
     */
    public function urlkeyFormatter() {
        return $this->category->formatUrlKey($this->getStringUtf8($this->getRow()[$this->getFieldTranslation(self::FIELD_CATEGORY_NAME)]));
    }

    /**
     * Rewrite this to change description
     * @return mixed
     */
    public function descriptionFormatter() {
        return $this->getStringUtf8($this->getRow()[$this->getFieldTranslation(self::FIELD_CATEGORY_DESCRIPTION)]);
    }

    /**
     * Rewrite this to change category meta title
     * @return mixed
     */
    public function metatitleFormatter() {
        return $this->getStringUtf8($this->getRow()[$this->getFieldTranslation(self::FIELD_CATEGORY_NAME)]);
    }

    /**
     * Rewrite this to change description
     * @return mixed
     */
    public function metadescriptionFormatter() {
        return $this->getStringUtf8($this->getRow()[$this->getFieldTranslation(self::FIELD_CATEGORY_DESCRIPTION)]);
    }

    /**
     * Rewrite this to change category name
     * @return mixed
     */
    public function nameFormatter() {
        return $this->getStringUtf8($this->getRow()[$this->getFieldTranslation(self::FIELD_CATEGORY_NAME)]);
    }

    /**
     * @return string
     */
    public function getCategoryIsActive() {
        return self::DEFAULT_CATEGORY_IS_ACTIVE;
    }

    /**
     * @return string
     */
    public function getCategoryIncludeInMenu() {
        return self::DEFAULT_CATEGORY_INCLUDE_IN_MENU;
    }

    /**
     * @return string
     */
    public function getCategoryAvailableSortBy() {
        return self::DEFAULT_CATEGORY_AVAILABLE_SORT_BY;
    }

    /**
     * @return string
     */
    public function getCategoryDefaultSortBy() {
        return self::DEFAULT_CATEGORY_DEFAULT_SORT_BY;
    }

    /**
     * @return string
     */
    public function getCategoryIsAnchor() {
        return self::DEFAULT_CATEGORY_IS_ANCHOR;
    }

}
