<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Model\Formatter;

abstract class AbstractFormatter {

    private $row;
    private $language = '';

    /**
     * @param array $row
     * @return $this
     */
    public function setRow(array $row) {
        $this->row = $row;
        return $this;
    }

    /**
     * @return array
     */
    public function getRow() {
        return $this->row;
    }

    /**
     * @param string $language
     * @return $this
     */
    public function setLanguage(string $language) {
        $this->language = $language;
        return $this;
    }

    /**
     * @return $this
     */
    public function resetLanguage() {
        $this->language = '';
        return $this;
    }

    /**
     * @return string
     */
    public function getLanguage() {
        return $this->language;
    }

    /**
     * @param string $fieldName
     * @return string
     */
    public function getFieldTranslation(string $fieldName) {
        if(!empty($this->getLanguage())) {
            return $fieldName . '_' . $this->getLanguage();
        }
        return $fieldName;
    }

    /**
     * Method to have secure utf8 string
     * @param $string
     * @return bool|string
     */
    public function getStringUtf8(string $string) {
        $decoded = utf8_decode($string);
        if (mb_detect_encoding($decoded , 'UTF-8', true) === false) {
            return $string;
        }
        return $decoded;
    }

}
