<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Model\Config\Source;

class ImportSheetTitle implements \Magento\Framework\Option\ArrayInterface
{
    /**
     * @var \Drop\GoogleApiAdapter\Model\Service\Spreadsheets
     */
    private $spreadsheets;
    /**
     * @var \Drop\Import\Helper\Product
     */
    private $productHelper;

    public $excludeSheetNames = [
        'UNDO_BLANK_DETECTOR'
    ];
    /**
     * @var \Magento\Framework\Message\ManagerInterface
     */
    private $messageManager;
    /**
     * @var \Magento\Framework\App\ResponseFactory
     */
    private $responseFactory;
    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $url;

    /**
     * ImportSheetTitle constructor.
     * @param \Drop\GoogleApiAdapter\Model\Service\Spreadsheets $spreadsheets
     * @param \Drop\Import\Helper\Product $productHelper
     * @param \Magento\Framework\App\ResponseFactory $responseFactory
     * @param \Magento\Framework\UrlInterface $url
     * @param \Magento\Framework\Message\ManagerInterface $messageManager
     */
    public function __construct(
        \Drop\GoogleApiAdapter\Model\Service\Spreadsheets $spreadsheets,
        \Drop\Import\Helper\Product $productHelper,
        \Magento\Framework\App\ResponseFactory $responseFactory,
        \Magento\Framework\UrlInterface $url,
        \Magento\Framework\Message\ManagerInterface $messageManager
    )
    {
        $this->spreadsheets = $spreadsheets;
        $this->productHelper = $productHelper;
        $this->messageManager = $messageManager;
        $this->responseFactory = $responseFactory;
        $this->url = $url;
    }

    /**
     * Options array
     *
     * @var array
     */
    protected $_options;

    /**
     * Return options array
     *
     * @return array
     */
    public function toOptionArray()
    {
        if (!$this->_options) {
            $this->_options = [
                ['value' => '', 'label' => 'Select a Sheet Title']
            ];

            $spreadSheetId = $this->productHelper->getSpreadsheetId();
            if(empty($spreadSheetId)) {
                return $this->_options;
            }

            try {
                $sheetTitles = $this->spreadsheets->getListOfSheetsTitle($spreadSheetId);
                foreach($sheetTitles as $title) {
                    if(in_array($title, $this->excludeSheetNames)) {
                        continue;
                    }
                    $this->_options[] = ['value' => $title,'label' => $title];
                }
            } catch (\Exception $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
                $redirectionUrl = $this->url->getUrl('adminhtml/system_config/edit/section/google_api_adapter');
                $this->responseFactory->create()->setRedirect($redirectionUrl)->sendResponse();
                exit();
            }

        }

        return $this->_options;
    }
}
