<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Model\Config\Source;

class ImportMethod implements \Magento\Framework\Option\ArrayInterface
{
    
    const IMPORT_METHOD_GOOGLE_DRIVE = 'google-drive';
    const IMPORT_METHOD_FILE_PATH_URL = 'file-path-url';

    /**
     * Options array
     *
     * @var array
     */
    protected $_options;

    /**
     * Return options array
     *
     * @return array
     */
    public function toOptionArray()
    {
        if (!$this->_options) {
            $this->_options = [
                ['value' => self::IMPORT_METHOD_GOOGLE_DRIVE, 'label' => __('Google Drive/Sheets')],
                ['value' => self::IMPORT_METHOD_FILE_PATH_URL, 'label' => __('Local file path/Download from remote url')]
            ];
        }

        return $this->_options;
    }
}
