<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Model\Config\Source;

class Behavior implements \Magento\Framework\Option\ArrayInterface
{

    const BEHAVIOR_UPDATE = 'update';

    /**
     * Options array
     *
     * @var array
     */
    protected $_options;

    /**
     * Return options array
     *
     * @return array
     */
    public function toOptionArray()
    {
        if (!$this->_options) {
            $this->_options = [
                ['value' => \Magento\ImportExport\Model\Import::BEHAVIOR_APPEND, 'label' => __('Only Add')],
                ['value' => self::BEHAVIOR_UPDATE, 'label' => __('Only Update')],
                ['value' => \Magento\ImportExport\Model\Import::BEHAVIOR_ADD_UPDATE, 'label' => __('Add or Update')],
                ['value' => \Magento\ImportExport\Model\Import::BEHAVIOR_REPLACE, 'label' => __('Replace')],
                ['value' => \Magento\ImportExport\Model\Import::BEHAVIOR_DELETE, 'label' => __('Delete')],
            ];
        }

        return $this->_options;
    }
}
