<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Model\Checkers\Entities\Product\Update;

use Drop\Import\Model\Checkers\CheckerInterface;
use \Drop\Import\Model\Checkers\Entities\Product;
use \Drop\Import\Model\Formatter\Product as RelatedProduct;

class Related extends Product implements CheckerInterface
{

    /**
     * @var \Drop\Import\Helper\Product
     */
    private $helper;
    /**
     * @var \Drop\Import\Model\Formatter\Product
     */
    private $formatter;
    /**
     * @var \Drop\Import\Model\AttributeFactory
     */
    private $attributeFactory;

    /**
     * Product constructor.
     * @param \Drop\Import\Helper\Product $helper
     * @param \Drop\Import\Model\Formatter\Product $formatter
     * @param \Drop\Import\Model\AttributeFactory $attributeFactory
     */
    public function __construct(
        \Drop\Import\Helper\Product $helper,
        \Drop\Import\Model\Formatter\Product $formatter,
        \Drop\Import\Model\AttributeFactory $attributeFactory
    )
    {
        $this->helper = $helper;
        $this->formatter = $formatter;
        $this->attributeFactory = $attributeFactory;

        parent::__construct($helper, $formatter, $attributeFactory);
    }

    public function validateData(array $inputData)
    {
        foreach($inputData as $key => $row) {

            $this->formatter->setRow($row);

            if(empty($this->formatter->skuFormatter())) {
                $this->addErrorMessage('Empty sku');
            } else {
                $this->getBehaviorExistanceErrors();
            }

            foreach(explode(RelatedProduct::DEFAULT_RELATED_DIVIDER, $this->formatter->relatedSkuFormatter()) as $relatedSku) {
                if(!$this->helper->getProductExistBySku($relatedSku)) {
                    $this->addErrorMessage('Related Product does not exist');
                }
            }
            foreach(explode(RelatedProduct::DEFAULT_RELATED_DIVIDER, $this->formatter->crosssellSkuFormatter()) as $crosssellSku) {
                if(!$this->helper->getProductExistBySku($crosssellSku)) {
                    $this->addErrorMessage('Crosssell Product does not exist');
                }
            }
            foreach(explode(RelatedProduct::DEFAULT_RELATED_DIVIDER, $this->formatter->upsellSkuFormatter()) as $upsellSku) {
                if(!$this->helper->getProductExistBySku($upsellSku)) {
                    $this->addErrorMessage('Upsell Product does not exist');
                }
            }

            $this->setRowIncrement();
        }

        return $this;
    }

}
