<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Model\Checkers\Entities;

use \Drop\Import\Model\Checkers\AbstractChecker;
use Drop\Import\Model\Checkers\CheckerInterface;

class Customer extends AbstractChecker implements CheckerInterface {
    
    /**
     * @var \Drop\Import\Helper\Customer
     */
    private $helper;
    /**
     * @var \Drop\Import\Model\Formatter\Customer
     */
    private $formatter;

    /**
     * Customer constructor.
     * @param \Drop\Import\Helper\Customer $helper
     * @param \Drop\Import\Model\Formatter\Customer $formatter
     */
    public function __construct(
        \Drop\Import\Helper\Customer $helper,
        \Drop\Import\Model\Formatter\Customer $formatter
    )
    {
        $this->helper = $helper;
        $this->formatter = $formatter;
    }

    public function validateData(array $inputData)
    {
        foreach($inputData as $key => $row) {

            $this->formatter->setRow($row);

            if(empty($row['email'])) {
                $this->addErrorMessage('Email empty');
            }
            if(!$this->helper->getEmailIsValid($row['email'])) {
                $this->addErrorMessage('Email invalid');
            }
            if(empty($row['firstname'])) {
                $this->addErrorMessage('Empty firstname');
            }
            if(empty($row['lastname'])) {
                $this->addErrorMessage('Empty lastname');
            }
            if(empty($this->formatter->ipAddressFormatter())) {
                $this->addErrorMessage('Empty ip_address');
            }
            if(!$this->helper->getIpIsValid($row['ip_address'])) {
                $this->addErrorMessage('Ip Address invalid');
            }
            if(empty($this->formatter->privacyFormatter())) {
                $this->addErrorMessage('Empty privacy_policy');
            }
            if(empty($this->formatter->profilingFormatter())) {
                $this->addErrorMessage('Empty profiling');
            }

            if(empty($row['country']) && empty($row['website_id']) && empty($row['website_code'])) {
                $this->addErrorMessage('Empty one of country/website_id/website_code');
            } else {
                if(isset($row['country'])) {
                    if(!$this->helper->getCountryExistByCode($row['country'])){
                        $this->addErrorMessage('country is not a valid field');
                    } else {
                        $row['website_id'] = $this->helper->getWebsiteByCountry($row['country']);
                    }
                }
                if(isset($row['website_id'])) {
                    if(!$this->helper->getWebsiteExistById($row['website_id'])) {
                        $this->addErrorMessage('website_id is not a valid field');
                    }
                }
                if(isset($row['website_code'])) {
                    if(!$this->helper->getWebsiteExistByCode($row['website_code'])) {
                        $this->addErrorMessage('website_code is not a valid field');
                    } else {
                        $row['website_id'] = $this->helper->getWebsiteIdByCode($row['website_code']);
                    }
                }

                if($this->helper->getCustomerExistByEmail($row['email'], $row['website_id'])) {
                    $this->addErrorMessage('Customer already exist');
                }

            }

            if(empty($this->formatter->genderFormatter())) {
                $this->addErrorMessage('Empty gender');
            }
            if(empty($this->formatter->privacyFormatter())) {
                $this->addErrorMessage('Empty privacy_policy');
            }
            if(empty($this->formatter->profilingFormatter())) {
                $this->addErrorMessage('Empty profiling');
            }

            //TODO: Date e gender/privacy/profiling validation
//            if(empty($this->formatter->dateFormatter())) {}

            $this->setRowIncrement();
        }

       return $this;
    }

}
