<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Model\Checkers\Entities;

use \Drop\Import\Model\Checkers\AbstractChecker;
use Drop\Import\Model\Checkers\CheckerInterface;

class Category extends AbstractChecker implements CheckerInterface {
    
    /**
     * @var \Drop\Import\Helper\Category
     */
    private $helper;
    /**
     * @var \Drop\Import\Model\Formatter\Category
     */
    private $formatter;

    /**
     * Category constructor.
     * @param \Drop\Import\Helper\Category $helper
     * @param \Drop\Import\Model\Formatter\Category $formatter
     */
    public function __construct(
        \Drop\Import\Helper\Category $helper,
        \Drop\Import\Model\Formatter\Category $formatter
    )
    {
        $this->helper = $helper;
        $this->formatter = $formatter;
    }

    public function validateData(array $inputData)
    {
        $translationLanguages = $this->getTranslationLanguage();
        foreach($inputData as $key => $row) {

            $this->formatter->setRow($row);

            if(empty($this->formatter->nameFormatter())) {
                $this->addErrorMessage('Empty categoria');
            }
            if(empty($this->formatter->urlkeyFormatter())) {
                $this->addErrorMessage('Empty url_key');
            }
            //TODO: check url_key already exist in Magento

            if(empty($this->formatter->metatitleFormatter())) {
                $this->addErrorMessage('Empty meta_title');
            } elseif(strlen($this->formatter->metatitleFormatter()) > self::DEFAULT_META_TITLE_LENGTH) {
                $this->addErrorMessage('Max meta_title length is ' . self::DEFAULT_META_TITLE_LENGTH . ' character');
            }

            if(empty($this->formatter->metadescriptionFormatter())) {
                $this->addErrorMessage('Empty meta_description');
            } elseif(strlen($this->formatter->metadescriptionFormatter()) > self::DEFAULT_META_DESCRIPTION_LENGTH) {
                $this->addErrorMessage('Max meta_description length is ' . self::DEFAULT_META_DESCRIPTION_LENGTH . ' character');
            }

            foreach($translationLanguages as $language) {
                if($language == $this->helper->getReferenceStoreCode()) {
                    continue;
                }

                $this->formatter->setLanguage($language);

                if(empty($this->formatter->nameFormatter())) {
                    $this->addErrorMessage('Empty categoria_' . $language);
                }
            }

            $this->formatter->resetLanguage();

            $this->setRowIncrement();
        }

       return $this;
    }

}
