<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Model\Checkers\Entities;

use \Drop\Import\Model\Checkers\AbstractChecker;
use Drop\Import\Model\Checkers\CheckerInterface;

class AttributeSet extends AbstractChecker implements CheckerInterface {
    
    /**
     * @var \Drop\Import\Helper\AttributeSet
     */
    private $helper;

    /**
     * AttributeSet constructor.
     * @param \Drop\Import\Helper\AttributeSet $helper
     */
    public function __construct(
        \Drop\Import\Helper\AttributeSet $helper
    )
    {
        $this->helper = $helper;
    }

    public function validateData(array $inputData)
    {
        $translationLanguages = $this->getTranslationLanguage();
        foreach($inputData as $key => $row) {
            if(empty($row['codice'])) {
                $this->addErrorMessage('Empty codice');
            }
            if(empty($row['taglia'])) {
                $this->addErrorMessage('Empty taglia');
            }
            if(empty($row['scaletaglie'])) {
                $this->addErrorMessage('Empty scaletaglie');
            }

            foreach($translationLanguages as $language) {
                if($language == $this->helper->getReferenceStoreCode()) {
                    continue;
                }
                
                if(empty($row['scaletaglie_' . $language])) {
                    $this->addErrorMessage('Empty scaletaglie_' . $language);
                }
//                if(empty($row['taglia_' . $language])) {
//                    $this->addErrorMessage('Empty taglia_' . $language);
//                }
            }

            $this->setRowIncrement();
        }

       return $this;
    }

}
