<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Model\Checkers\Entities;

use \Drop\Import\Model\Checkers\AbstractChecker;
use Drop\Import\Model\Checkers\CheckerInterface;

class Attribute extends AbstractChecker implements CheckerInterface {
    
    /**
     * @var \Drop\Import\Helper\Attribute
     */
    private $helper;

    private $attributeTypology = [
        'select', 'multiselect', 'text', 'boolean'
    ];
    private $canBeEmptyAttributes = [
        'text', 'boolean'
    ];
    private $scope = [
        'global',
        'store'
    ] ;

    /**
     * Attribute constructor.
     * @param \Drop\Import\Helper\Attribute $helper
     */
    public function __construct(
        \Drop\Import\Helper\Attribute $helper
    )
    {
        $this->helper = $helper;
    }


    public function validateData(array $inputData)
    {
        $translationLanguages = $this->getTranslationLanguage();
        foreach($inputData as $key => $row) {
            if(empty($row['attributo'])) {
                $this->addErrorMessage('Empty attributo');
            }
            if(empty($row['tipo'])) {
                $this->addErrorMessage('Empty tipo');
            }
            if(empty($row['etichetta'])) {
                $this->addErrorMessage('Empty etichetta');
            }
            if(empty($row['scope'])) {
                $this->addErrorMessage('Empty scope');
            } elseif(!in_array($row['scope'], $this->scope)) {
                $this->addErrorMessage('Invalid scope');
            }

            if(!in_array($row['tipo'], $this->attributeTypology)) {
                $this->addErrorMessage('Wrong tipo');
            }
            if((!isset($row['valori']) || empty($row['valori'])) && !in_array($row['tipo'], $this->canBeEmptyAttributes)) {
                $this->addErrorMessage('Empty valori');
            }

            //Translation rows
            foreach($translationLanguages as $language) {
//                if($language == $this->helper->getReferenceStoreCode()) {
//                    continue;
//                }

                if(empty($row['etichetta_' . $language])) {
                    $this->addErrorMessage('Empty etichetta_' . $language);
                }
                if((!isset($row['valori_' . $language]) || empty($row['valori_' . $language])) && !in_array($row['tipo'], $this->canBeEmptyAttributes)) {
                    $this->addErrorMessage('Empty valori');
                }
            }

            $this->setRowIncrement();
        }

       return $this;
    }

}
