<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Model\Checkers\Command;

use \Drop\Import\Model\Checkers\AbstractChecker;
use Drop\Import\Model\Checkers\CheckerInterface;

class UrlRewrite extends AbstractChecker implements CheckerInterface {

    /**
     * @var \Drop\Import\Helper\Checker
     */
    private $helper;
    private $redirectTypes = [301, 302];

    /**
     * UrlRewrite constructor.
     * @param \Drop\Import\Helper\UrlRewrite $helper
     */
    public function __construct(
        \Drop\Import\Helper\UrlRewrite $helper
    )
    {
        $this->helper = $helper;
    }

    public function validateData(array $inputData)
    {
        foreach($inputData as $key => $row) {
            if(empty($row['request_path'])) {
                $this->addErrorMessage("Empty request_path.");
            }
            if(empty($row['target_path'])) {
                $this->addErrorMessage("Empty target_path.");
            }
            if(empty($row['store_id'])) {
                $this->addErrorMessage("Empty store_id.");
            } else {
                if(!$this->helper->getStoreExistById($row['store_id'])) {
                    $this->addErrorMessage('store_id is not a valid field');
                }
            }
            if(empty($row['redirect_type'])) {
                $this->addErrorMessage("Empty store_id.");
            } else {
                if(!in_array($row['redirect_type'], $this->redirectTypes)) {
                    $this->addErrorMessage('redirect_type is not a valid field');
                }
            }

            $this->setRowIncrement();
        }

        return $this;
    }

}
