<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Model\Checkers\Command;

use \Drop\Import\Model\Checkers\AbstractChecker;
use Drop\Import\Model\Checkers\CheckerInterface;

class Subscriber extends AbstractChecker implements CheckerInterface {
    
    /**
     * @var \Drop\Import\Helper\Checker
     */
    private $helper;

    /**
     * Subscriber constructor.
     * @param \Drop\Import\Helper\Subscriber $helper
     */
    public function __construct(
        \Drop\Import\Helper\Subscriber $helper
    )
    {
        $this->helper = $helper;
    }

    public function validateData(array $inputData)
    {
        foreach($inputData as $key => $row) {
            if(empty($row['email'])) {
                $this->addErrorMessage('Empty email');
            }
            if ($this->helper->getEmailIsValid($row['email'])) {
                $this->addErrorMessage('email is not a valid field');
            }

            if(empty($row['country']) && empty($row['store_id']) && empty($row['store_code'])) {
                $this->addErrorMessage('Fields country/store_id/store_code are all empty');
            } else {
                if(isset($row['country']) && !$this->helper->getCountryExistByCode($row['country'])) {
                    $this->addErrorMessage('country is not a valid field');
                }
                if(isset($row['store_id']) && !$this->helper->getStoreExistById($row['store_id'])) {
                    $this->addErrorMessage('store_id is not a valid field');
                }
                if(isset($row['store_code']) && !$this->helper->getStoreExistByCode($row['store_code'])) {
                    $this->addErrorMessage('store_code is not a valid field');
                }
            }

            $this->setRowIncrement();
        }

       return $this;
    }

}
