<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Model\Checkers;

abstract class AbstractChecker
{

    const DEFAULT_META_TITLE_LENGTH = 60;
    const DEFAULT_META_DESCRIPTION_LENGTH = 158;

    /**
     * @var array
     */
    public $errorMessages = [];
    public $warningMessage = [];
    public $translationLanguage = [];
    public $header = [];
    public $validationResult = true;
    public $row = 2;

    /**
     * @return mixed
     */
    public function getErrorMessages() {
        return $this->errorMessages;
    }

    /**
     * @return mixed
     */
    public function getWarningMessages() {
        return $this->warningMessage;
    }

    /**
     * @return bool
     */
    public function getValidationResult() {
        return $this->validationResult;
    }

    /**
     * @param string $errorMessage
     * @param int $row
     * @return $this
     */
    protected function addErrorMessage(string $errorMessage) {
        $this->errorMessages[] = $errorMessage . ' at row ' . $this->row;
        $this->validationResult = false;
        return $this;
    }

    /**
     * @param string $warningMessage
     * @return $this
     */
    protected function addWarningMessage(string $warningMessage) {
        $this->warningMessage[] = $warningMessage;
        return $this;
    }

    /**
     * @return $this
     */
    protected function setRowIncrement() {
        $this->row++;
        return $this;
    }

    /**
     * @return $this
     */
    protected function setRowDecrement() {
        $this->row--;
        return $this;
    }

    /**
     * @param array $translationLanguage
     * @return $this
     */
    public function setTranslationLanguage(array $translationLanguage) {
        $this->translationLanguage = $translationLanguage;
        return $this;
    }

    /**
     * @return array
     */
    protected function getTranslationLanguage() {
        return $this->translationLanguage;
    }

    /**
     * @param array $header
     * @return $this
     */
    public function setHeader(array $header) {
        $this->header = $header;
        return $this;
    }

    /**
     * @return array
     */
    protected function getHeader() {
        return $this->header;
    }

}
